% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.R
\name{as_music_df}
\alias{as_music_df}
\title{Noteworthy string to data frame}
\usage{
as_music_df(
  notes,
  info = NULL,
  key = NULL,
  scale = "diatonic",
  chords = c("root", "list", "character"),
  si_format = c("mmp_abb", "mmp", "ad_abb", "ad")
)
}
\arguments{
\item{notes}{character, a noteworthy string. Alternatively, a music object
or a phrase object, in which case \code{info} is ignored.}

\item{info}{\code{NULL} or character, a note info string.}

\item{key}{character, key signature, only required for inclusion of scale
degrees.}

\item{scale}{character, defaults to \code{"diatonic"}. Only used in
conjunction with \code{key}, this can be used to alter scale degrees. Not
any arbitrary combination of valid \code{key} and valid \code{scale} is
valid. See \code{\link{scale_degree}}.}

\item{chords}{character, how to structure columns containing multiple values
per chord/row of data frame. See details.}

\item{si_format}{character, format for scale intervals. See
\code{\link{scale_interval}}.}
}
\value{
a tibble data frame
}
\description{
Convert a noteworthy string to a tibble data frame and include additional
derivative variables.
}
\details{
If \code{info} is provided or \code{notes} is a phrase object, the
resulting data frame also contains note durations and other info variables.
The \code{duration} column is always included in the output even as a vector
of \code{NA}s when \code{info = NULL}. This makes it more explicit that a
given music data frame was generated without any time information for the
timesteps. Other note info columns are not included in this case.

For some derived column variables the root note (lowest pitch) in chord is
used. This is done for pitch intervals and scale intervals between adjacent
timesteps. This also occurs for scale degrees.

\code{chord = "root"} additionally collapses columns like semitone, octave,
and frequency to the value for the root note so that all rows contain one
numeric value. \code{chord = "list"} retains full information as list
columns. \code{chord = "character"} collapses into strings so that values are
readily visible when printing the table, but information is not stripped and
can be recovered without recomputing from the original pitches.
}
\examples{
x <- "a, b, c d e f g# a r ac'e' a c' e' c' r r r a"
as_music_df(x, key = "c", scale = "major")
as_music_df(x, key = "am", scale = "harmonic_minor", si_format = "ad_abb")

a <- notate("8", "Start here.")
time <- paste(a, "8^*2 16-_ 4.. 16( 16)( 2) 2 4. t8- t8 t8- 8[accent]*4 1")
d1 <- as_music_df(x, time)
d1

# Go directly from music object to data frame
m1 <- as_music(x, time)
d2 <- as_music_df(m1)
identical(d1, d2)

# Go directly from phrase object to data frame
p1 <- phrase("a b cgc'", "4-+ 4[accent] 2", 5)
identical(as_music_df(as_music("a4-+;5 b[accent] cgc'2")), as_music_df(p1))
}
