% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table3.R
\name{table3}
\alias{table3}
\title{Table 3}
\usage{
table3(
  x,
  y,
  y_time,
  adj,
  data,
  split_var,
  split_div = c(),
  outformat = 4,
  method = "general"
)
}
\arguments{
\item{x}{A string. The independent variable to be summarized given as a string.}

\item{y}{A string. The dependent variable to be summarized given as a string.}

\item{y_time}{A string. The survival time variable to be summarized given as a string. It only works when \code{method = "cox"}.}

\item{adj}{A vector of strings. Moderator variables to be summarized given as a character vector.}

\item{data}{A data frame in which these variables exist.}

\item{split_var}{A vector of strings. Strata variables to be summarized given as a character vector.}

\item{split_div}{A list containing numeric vectors, default \code{= list()}.}

\item{outformat}{\code{1} or \code{2} or \code{3} or \code{4}, default \code{= 4}. Output format.}

\item{method}{(\code{"general"}, \code{"logistic"}, \code{"cox"}), default \code{= "general"}.}
}
\value{
An object about stratified analysis.
}
\description{
Creates 'Table 3' which is about stratified analysis. The three regression methods include general linear regression, logistic regression and cox proportional hazards regression.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##The censored data is not discussed here
pbc_full <- subset(pbc,status!=0)
pbc_full$status <- pbc_full$status-1
## Make categorical variables factors
varsToFactor <- c('status','trt','ascites','hepato','spiders','edema','stage','sex')
pbc_full[varsToFactor] <- lapply(pbc_full[varsToFactor], factor)

## Moderator variables
adj_pbc <- c('age','alk.phos','ast')
## Converts the continuous variables named 'albumin' to a categorical variable named 'albumin_2'.
albumin_2 <- div_quantile('albumin',div = c(2),pbc_full)
pbc_full <- data.frame(pbc_full,'albumin_2' = albumin_2)

## General linear regression:
table3(x = 'albumin_2', y = 'bili',
       adj = adj_pbc, data = pbc_full,
       split_var = c('age','alk.phos','ast','trt'), split_div = list(),
       outformat = 1)

## Logistic regression:
table3(x = 'albumin_2', y = 'status',
       adj = adj_pbc, data = pbc_full,
       split_var = c('age','alk.phos','ast','trt'), split_div = list(c(45)),
       outformat = 2,method = 'logistic')

## Cox proportional hazards regression:
table3(x = 'albumin_2',y = 'status',y_time = 'time',
       adj = adj_pbc,data = pbc_full,
       split_var = c('age','alk.phos','ast','trt'), split_div = list(c(45),c(1500,1700),c(),c()),
       outformat = 3,method = 'cox')
}
