% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UTILS-frame_append.R
\name{frame_append}
\alias{frame_append}
\title{Append expressions to the frame}
\usage{
frame_append(.data, ..., .parse = getOption("table.express.parse", FALSE))
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Expressions to add to the frame.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}
}
\description{
Add named expressions for the \link[data.table:data.table-class]{data.table::data.table} frame.
}
\examples{

data.table::data.table() \%>\%
    start_expr \%>\%
    frame_append(anything = "goes")

}
