% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_Chaotic.R
\name{data.gen.Duffing}
\alias{data.gen.Duffing}
\title{Duffing map}
\usage{
data.gen.Duffing(
  nobs = 5000,
  a = 2.75,
  b = 0.2,
  start = runif(n = 2, min = -0.5, max = 0.5),
  s,
  do.plot = TRUE
)
}
\arguments{
\item{nobs}{Length of the generated time series. Default: 5000 samples.}

\item{a}{The \emph{a} parameter. Default: 2.75.}

\item{b}{The \emph{b} parameter. Default: 0.2.}

\item{start}{A 2-dimensional vector indicating the starting values for the x and y Duffing coordinates.
Default: If the starting point is not specified, it is generated randomly.}

\item{s}{The level of noise, default 0.}

\item{do.plot}{Logical value. If TRUE (default value), a plot of the generated Duffing system is shown.}
}
\value{
A list with two vectors named \emph{x} and \emph{y} containing the
x-components and the y-components of the Duffing map, respectively.
}
\description{
Generates a 2-dimensional time series using the Duffing map.
}
\details{
The Duffing map is defined as follows:
\deqn{ x_n = y_{n - 1}}{x[n] = y[n - 1]}
\deqn{ y_n = -b \cdot x_{n - 1} + a \cdot y_{n - 1} - y_{n - 1}^3}{y[n] = -b*x[n - 1] + a*y[n-1] - y[n-1]^3.}
The default selection for both \emph{a} and \emph{b} parameters
(\emph{a}=1.4 and \emph{b}=0.3) is known to produce a deterministic chaotic
time series.
}
\note{
Some initial values may lead to an unstable system that will tend to infinity.
}
\examples{
Duffing.map=data.gen.Duffing(nobs = 1000, do.plot=TRUE)
}
\references{
Constantino A. Garcia (2019). nonlinearTseries: Nonlinear Time Series Analysis. R package version 0.2.7. https://CRAN.R-project.org/package=nonlinearTseries
}
