% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_AR.R
\name{data.gen.tar2}
\alias{data.gen.tar2}
\title{Generate predictor and response data from TAR2 model.}
\usage{
data.gen.tar2(nobs, ndim = 9, noise = 0.1)
}
\arguments{
\item{nobs}{The data length to be generated.}

\item{ndim}{The number of potential predictors (default is 9).}

\item{noise}{The white noise in the data}
}
\value{
A list of 2 elements: a vector of response (x), and a matrix of potential predictors (dp) with each column containing one potential predictor.
}
\description{
Generate predictor and response data from TAR2 model.
}
\examples{
# TAR2 model from paper with total 9 dimensions
data.tar2<-data.gen.tar2(500)
plot.ts(cbind(data.tar2$x,data.tar2$dp))
}
\references{
Sharma, A. (2000). Seasonal to interannual rainfall probabilistic forecasts for improved water supply management: Part 1—A strategy for system predictor identification. Journal of Hydrology, 239(1-4), 232-239.
}
