% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grapheme.R
\docType{class}
\name{Grapheme-class}
\alias{Grapheme-class}
\alias{Grapheme}
\title{A Reference Class for representing consistency test graphemes}
\description{
A Reference Class for representing consistency test graphemes
}
\section{Fields}{

\describe{
\item{\code{symbol}}{A one-element character vector containing the symbol/set of symbols
that describe(s) the grapheme, e. g. '7' or 'Monday'. Set at class new() call or using set_symbol method.}

\item{\code{response_colors}}{A matrix where each row specifies color coordinates for each participant
response. Set using set_colors method.}

\item{\code{response_times}}{A numeric vector of response times. Set using set_times method.}

\item{\code{color_space}}{A one-element character vector which describes the color space
that response colors are coded in. Set when using set_colors method.}
}}

\section{Methods}{

\describe{
\item{\code{get_abbreviated_symbol()}}{Return a short (3 character) representation of
the grapheme's symbol.}

\item{\code{get_consistency_score(na.rm = FALSE, method = "euclidean")}}{Calculate the consistency score based on the
Grapheme instance's response colors. Throws an
error if no responses have been registered yet.
Always returns NA if all grapheme responses are NA.
If na.rm=FALSE, returns NA if any grapheme response
is NA. If na.rm=TRUE, returns the consistency score
for non-NA responses. This function relies on the
base/stats function dist() and so supports only
distance calculation methods implemented by dist()
(use help(dist) to learn more about it).}

\item{\code{get_mean_color(na.rm = FALSE)}}{Average all registered response colors and
return the result (using the color space
set at grapheme initialization) as a 3-element vector.
Example: if color space is RGB, element 1 represents
mean R value, element 2 mean G value, element 3
B value.

If na.rm=FALSE and any of the response colors is missing,
return a 3-element NA vector. If na.rm=TRUE, return a
3-element NA vector if all response colors are missing,
otherwise return mean of all available colors.}

\item{\code{get_mean_response_time(na.rm = FALSE)}}{Get the mean of the grapheme's associated
response times.}

\item{\code{get_num_non_na_colors()}}{Get the number of response colors that are non-NA, returned as
a one-element numeric vector.}

\item{\code{get_plot_data_list()}}{Get a list of the grapheme's data, bundled up in
a format ready for use in Participant.get_plot_data()
method as a row of plot
data.}

\item{\code{has_only_non_na_colors()}}{Returns TRUE if the grapheme only has responses with valid colors,
FALSE if there are responses with nonvalid colors or there are
no responses at all.}

\item{\code{set_colors(hex_codes, color_space_spec)}}{Set response colors, using passed RGB hex codes. Converts
the hex codes to color coordinates in the specified
color space. Supports the following color spaces:
"XYZ", "sRGB", "Apple RGB", "Lab", and "Luv".
For all NA values passed, a row of NA values will be included
in the matrix (preserving order of responses). Returned/set
response colors are in the format of a matrix where each
row represents one response/color, and each
column represents one color coordinate axis (there are always
3 axes used for the currently supported color spaces)}

\item{\code{set_symbol(symbol_chars)}}{Set the grapheme's symbol attribute, using a passed
one-element character vector.}

\item{\code{set_times(times)}}{Add response times, using passed numeric vector.}
}}

\examples{
a <- synr::Grapheme$new(symbol='a')
a$set_colors(c("#101010", NA), "Luv")
a$set_times(c(5, 10))
a$get_num_non_na_colors()
}
