% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_clas.R
\name{plot_clas}
\alias{plot_clas}
\title{Synoptic classification plot}
\usage{
plot_clas(longitude, latitude, grouped_data, cwt_number,
  divide_units = 100, zmin, zmax, legend.lab = "", ...)
}
\arguments{
\item{longitude}{Numeric. vector containing longitudes.}

\item{latitude}{Numeric. vector containing latitudes.}

\item{grouped_data}{Data frame. S-mode data frame containing an integer column with the weather types. i.e. output obtained from \code{synoptclas} function.}

\item{cwt_number}{Integer. Number of CWT to plot.}

\item{divide_units}{Integer to divide previous units. Default is 100.}

\item{zmin}{Integer. Minimum value to represent. Useful if you display many plots. Optional.}

\item{zmax}{Integer. Maximum value to represent. Useful if you display many plots. Optional.}

\item{legend.lab}{Character. Name of the variable used.}

\item{...}{Other graphical parameters.}
}
\description{
Plot the synoptic classification
}
\examples{
# Load data (mslp)
data(mslp)
# Converting our data into a S-mode, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp, only_convert = TRUE)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)
# Plot circulation weather type number 3
plot_clas(longitude = mslp$lon, latitude = mslp$lat,
          grouped_data = smode_clas$grouped_data,
          cwt_number = 3)

}
\seealso{
\code{\link{synoptclas}}
}
