/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sample.DiploidStates;
import sample.RecombSingleBaumLevel;
import sample.RecombSingleNodes;
import sample.RestrictedDag;
import sample.SamplerData;
import sample.SingleBaumInterface;
import vcf.GL;

public class RecombSingleBaum
implements SingleBaumInterface {
    private final SamplerData samplerData;
    private final Dag dag;
    private final RestrictedDag rdag;
    private final GL gl;
    private final int nMarkers;
    private final int nSamplesPerIndividual;
    private final long seed;
    private final Random random;
    private final int[] node1;
    private final int[] node2;
    private final float[] baseTrProb;
    private final float[] maxSum;
    private final int[][] alleles1;
    private final int[][] alleles2;
    private final RecombSingleBaumLevel[] levels;
    private final RecombSingleNodes fwdNodes;
    private final RecombSingleNodes bwdNodes;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public RecombSingleBaum(SamplerData samplerData, long l, int n, boolean bl) {
        if (n < 1) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.samplerData = samplerData;
        this.dag = samplerData.rdag().dag();
        this.rdag = samplerData.rdag();
        this.gl = samplerData.gl();
        this.nMarkers = samplerData.nMarkers();
        this.nSamplesPerIndividual = n;
        this.seed = l;
        this.random = new Random(l);
        this.node1 = new int[n];
        this.node2 = new int[n];
        this.baseTrProb = new float[n];
        this.maxSum = new float[n];
        this.alleles1 = new int[n][this.nMarkers];
        this.alleles2 = new int[n][this.nMarkers];
        int n2 = this.dag.nLevels();
        if (bl) {
            n2 = (int)Math.ceil(Math.sqrt(1 + 8 * this.dag.nLevels()) / 2.0) + 1;
        }
        this.levels = new RecombSingleBaumLevel[n2];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new RecombSingleBaumLevel(samplerData);
        }
        this.fwdNodes = new RecombSingleNodes(this.dag.maxNodes());
        this.bwdNodes = new RecombSingleNodes(this.dag.maxNodes());
    }

    @Override
    public Dag dag() {
        return this.rdag.dag();
    }

    @Override
    public GL gl() {
        return this.gl;
    }

    @Override
    public int nSamplesPerIndividual() {
        return this.nSamplesPerIndividual;
    }

    @Override
    public long seed() {
        return this.seed;
    }

    @Override
    public List<HapPair> randomSample(int n) {
        DiploidStates diploidStates = this.rdag.singleStates(n);
        this.forwardAlgorithm(n, diploidStates);
        this.initSampleAlleles(this.currentLevel(), n);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            RecombSingleBaumLevel recombSingleBaumLevel = this.previousLevel(n, diploidStates);
            this.sampleAlleles(recombSingleBaumLevel, n);
        }
        this.pruneLevels();
        return this.hapList(n);
    }

    @Override
    public List<HapPair> randomSample(int n, double[] dArray) {
        this.checkGprobs(dArray);
        DiploidStates diploidStates = this.rdag.singleStates(n);
        this.forwardAlgorithm(n, diploidStates);
        this.initSampleAlleles(this.currentLevel(), n);
        this.currentLevel().setInitialBackwardValues(this.bwdNodes);
        this.setGprobs(this.currentLevel(), dArray);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            RecombSingleBaumLevel recombSingleBaumLevel = this.previousLevel(n, diploidStates);
            this.sampleAlleles(recombSingleBaumLevel, n);
            recombSingleBaumLevel.setBackwardValues(this.bwdNodes);
            this.setGprobs(recombSingleBaumLevel, dArray);
        }
        this.pruneLevels();
        return this.hapList(n);
    }

    private void pruneLevels() {
        int n = this.estMeanSize();
        int n2 = 3 * n;
        int n3 = 3 * n / 2 + 1;
        for (int i = 0; i < this.levels.length; ++i) {
            if (this.levels[i].capacity() <= n2) continue;
            this.levels[i].reset(n3);
        }
    }

    private int estMeanSize() {
        int n = 20;
        long l = 0L;
        for (int i = 0; i < n; ++i) {
            l += (long)this.levels[this.random.nextInt(this.levels.length)].size();
        }
        return (int)(l / (long)n);
    }

    private void checkGprobs(double[] dArray) {
        int n = this.gl.markers().sumGenotypes();
        if (dArray.length != n) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
    }

    private void setGprobs(RecombSingleBaumLevel recombSingleBaumLevel, double[] dArray) {
        if (dArray != null) {
            int n = recombSingleBaumLevel.marker();
            int n2 = this.gl.marker(n).nGenotypes();
            int n3 = this.gl.markers().sumGenotypes(n);
            for (int i = 0; i < n2; ++i) {
                dArray[n3 + i] = recombSingleBaumLevel.gprobs(i);
            }
        }
    }

    private List<HapPair> hapList(int n) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(2 * this.nSamplesPerIndividual);
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            BitHapPair bitHapPair = new BitHapPair(this.gl.markers(), this.gl.samples(), n, this.alleles1[i], this.alleles2[i]);
            arrayList.add(bitHapPair);
        }
        return arrayList;
    }

    private void initSampleAlleles(RecombSingleBaumLevel recombSingleBaumLevel, int n) {
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            this.saveCurrentData(recombSingleBaumLevel, n, i, this.initialRandomState(recombSingleBaumLevel));
        }
    }

    private int initialRandomState(RecombSingleBaumLevel recombSingleBaumLevel) {
        float f = this.random.nextFloat();
        float f2 = 0.0f;
        int n = recombSingleBaumLevel.size();
        for (int i = 0; i < n; ++i) {
            if (!(f <= (f2 += recombSingleBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return recombSingleBaumLevel.size() - 1;
    }

    private void saveCurrentData(RecombSingleBaumLevel recombSingleBaumLevel, int n, int n2, int n3) {
        int n4 = recombSingleBaumLevel.marker();
        int n5 = recombSingleBaumLevel.edge1(n3);
        int n6 = recombSingleBaumLevel.edge2(n3);
        int n7 = recombSingleBaumLevel.symbol1(n3);
        int n8 = recombSingleBaumLevel.symbol2(n3);
        this.node1[n2] = recombSingleBaumLevel.parentNode1(n3);
        this.node2[n2] = recombSingleBaumLevel.parentNode2(n3);
        float f = this.dag.edgeProb(n4, n5);
        float f2 = this.dag.edgeProb(n4, n6);
        this.baseTrProb[n2] = f * f2;
        this.maxSum[n2] = recombSingleBaumLevel.forwardValue(n3) * recombSingleBaumLevel.forwardValuesSum() / this.gl.gl(n4, n, n7, n8);
        this.alleles1[n2][n4] = n7;
        this.alleles2[n2][n4] = n8;
    }

    private void sampleAlleles(RecombSingleBaumLevel recombSingleBaumLevel, int n) {
        for (int i = 0; i < this.nSamplesPerIndividual; ++i) {
            this.saveCurrentData(recombSingleBaumLevel, n, i, this.randomPreviousState(recombSingleBaumLevel, i));
        }
    }

    private int randomPreviousState(RecombSingleBaumLevel recombSingleBaumLevel, int n) {
        int n2 = recombSingleBaumLevel.marker();
        float f = this.dag.parentProb(n2 + 1, this.node1[n]);
        float f2 = this.dag.parentProb(n2 + 1, this.node2[n]);
        float f3 = this.samplerData.pRecomb(n2 + 1);
        float f4 = this.random.nextFloat() * this.maxSum[n];
        float f5 = 0.0f;
        int n3 = recombSingleBaumLevel.size();
        for (int i = 0; i < n3; ++i) {
            boolean bl;
            float f6 = 0.0f;
            boolean bl2 = recombSingleBaumLevel.childNode1(i) == this.node1[n];
            boolean bl3 = bl = recombSingleBaumLevel.childNode2(i) == this.node2[n];
            if (bl2 && bl) {
                f6 += (1.0f - f3) * (1.0f - f3) * this.baseTrProb[n] / (f * f2);
            }
            if (bl2) {
                f6 += (1.0f - f3) * f3 * this.baseTrProb[n] / f;
            }
            if (bl) {
                f6 += f3 * (1.0f - f3) * this.baseTrProb[n] / f2;
            }
            f6 += f3 * f3 * this.baseTrProb[n];
            if (!(f4 <= (f5 += recombSingleBaumLevel.forwardValue(i) * f6))) continue;
            return i;
        }
        return recombSingleBaumLevel.size() - 1;
    }

    private RecombSingleBaumLevel nextLevel() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.levels.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.levels[this.arrayIndex];
    }

    private RecombSingleBaumLevel currentLevel() {
        return this.levels[this.arrayIndex];
    }

    private RecombSingleBaumLevel previousLevel(int n, DiploidStates diploidStates) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            this.levels[this.arrayIndex].setChildNodes(this.fwdNodes);
            int n2 = this.levels[this.windowIndex].marker() + 1;
            int n3 = n2 + (this.levels.length - (this.windowIndex + 1));
            for (int i = n2; i < n3; ++i) {
                this.nextLevel().setForwardValues(this.fwdNodes, diploidStates, i, n);
            }
            return this.currentLevel();
        }
        return this.levels[--this.arrayIndex];
    }

    private void forwardAlgorithm(int n, DiploidStates diploidStates) {
        this.fwdNodes.clear();
        this.fwdNodes.sumUpdate(0, 0, 1.0f);
        this.windowIndex = -1;
        this.arrayIndex = this.levels.length - 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            this.nextLevel().setForwardValues(this.fwdNodes, diploidStates, i, n);
        }
    }
}

