/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.SampleHapPairs;
import vcf.Marker;
import vcf.Markers;
import vcf.VcfEmission;

public class RefHapPairs
implements SampleHapPairs {
    private final Markers markers;
    private final Samples samples;
    private final VcfEmission[] phasedMarkers;

    public RefHapPairs(Markers markers, Samples samples, VcfEmission[] vcfEmissionArray) {
        RefHapPairs.checkPhasedMarkers(markers, samples, vcfEmissionArray);
        this.markers = markers;
        this.samples = samples;
        this.phasedMarkers = (VcfEmission[])vcfEmissionArray.clone();
    }

    private static void checkPhasedMarkers(Markers markers, Samples samples, VcfEmission[] vcfEmissionArray) {
        if (markers.nMarkers() != vcfEmissionArray.length) {
            String string = "markers.nMarkers()=" + markers.nMarkers() + " phasedMarkers.length=" + vcfEmissionArray.length;
            throw new IllegalArgumentException(string);
        }
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (!vcfEmissionArray[i].samples().equals(samples)) {
                String string = "sample inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (!vcfEmissionArray[i].marker().equals(markers.marker(i))) {
                String string = "marker inconsistency at index " + i;
                throw new IllegalArgumentException(string);
            }
            if (vcfEmissionArray[i].isRefData()) continue;
            String string = "non-reference data at marker index " + i;
            throw new IllegalArgumentException(string);
        }
    }

    @Override
    public byte allele1(int n, int n2) {
        return this.phasedMarkers[n].allele1(n2);
    }

    @Override
    public byte allele2(int n, int n2) {
        return this.phasedMarkers[n].allele2(n2);
    }

    @Override
    public byte allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.phasedMarkers[n].allele1(n3);
        }
        return this.phasedMarkers[n].allele2(n3);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nHapPairs() {
        return this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int idIndex(int n) {
        return this.samples.idIndex(n);
    }
}

