/*
 * Decompiled with CFR 0.152.
 */
package sample;

import blbutil.Utilities;
import haplotype.HapPair;
import haplotype.RevHapPair;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import main.GenotypeValues;
import sample.SingleBaumInterface;

public class ProduceSingleSamples
implements Runnable {
    public static final Integer POISON = -1;
    private final boolean markersAreReversed;
    private final SingleBaumInterface baum;
    private final BlockingQueue<Integer> qIn;
    private final List<HapPair> sampledHaps;
    private final GenotypeValues gv;
    private final double[] gprobs;

    public ProduceSingleSamples(boolean bl, SingleBaumInterface singleBaumInterface, BlockingQueue<Integer> blockingQueue, List<HapPair> list) {
        if (singleBaumInterface == null) {
            throw new NullPointerException("baum=null");
        }
        if (blockingQueue == null) {
            throw new IllegalArgumentException("qIn==null");
        }
        if (list == null) {
            throw new IllegalArgumentException("hapList==null");
        }
        this.markersAreReversed = bl;
        this.baum = singleBaumInterface;
        this.qIn = blockingQueue;
        this.sampledHaps = list;
        this.gv = null;
        this.gprobs = null;
    }

    public ProduceSingleSamples(boolean bl, SingleBaumInterface singleBaumInterface, BlockingQueue<Integer> blockingQueue, List<HapPair> list, GenotypeValues genotypeValues) {
        if (singleBaumInterface == null) {
            throw new NullPointerException("baum=null");
        }
        if (blockingQueue == null) {
            throw new IllegalArgumentException("qIn==null");
        }
        if (list == null) {
            throw new IllegalArgumentException("hapList==null");
        }
        if (genotypeValues == null) {
            throw new IllegalArgumentException("gv==null");
        }
        this.markersAreReversed = bl;
        this.baum = singleBaumInterface;
        this.qIn = blockingQueue;
        this.gv = genotypeValues;
        this.sampledHaps = list;
        int n = singleBaumInterface.gl().markers().sumGenotypes();
        this.gprobs = new double[n];
    }

    @Override
    public void run() {
        try {
            int n = this.qIn.take();
            while (n != POISON) {
                List<HapPair> list;
                if (this.gv == null) {
                    list = this.baum.randomSample(n);
                    this.storeHaps(list);
                } else {
                    list = this.baum.randomSample(n, this.gprobs);
                    this.storeHaps(list);
                    this.gv.add(n, this.gprobs);
                }
                n = this.qIn.take();
            }
        }
        catch (Throwable throwable) {
            Utilities.exit("ProduceSingleSamples: ERROR", throwable);
        }
    }

    private void storeHaps(List<HapPair> list) {
        if (this.markersAreReversed) {
            for (HapPair hapPair : list) {
                this.sampledHaps.add(new RevHapPair(hapPair));
            }
        } else {
            this.sampledHaps.addAll(list);
        }
    }
}

