% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_wild.R
\name{wild.boot}
\alias{wild.boot}
\title{Wild bootstrap for IRFs of identified SVARs}
\usage{
wild.boot(x, rademacher = FALSE, horizon, nboot, nc = 1, dd = NULL,
  itermax = 300, steptol = 200, iter2 = 50)
}
\arguments{
\item{x}{SVAR object of class "svars"}

\item{rademacher}{If rademacher="TRUE", the Rademacher distribution is used to generate the bootstrap samples}

\item{horizon}{Time horizon for impulse response functions}

\item{nboot}{Number of bootstrap iterations}

\item{nc}{Number of processor cores (Not available on windows machines)}

\item{dd}{Object of class 'indepTestDist'. A simulated independent sample of the same size as the data. If not supplied, it will be culculated by the function}

\item{itermax}{Maximum number of iterations for DEoptim}

\item{steptol}{Tolerance for steps without improvement for DEoptim}

\item{iter2}{Number of iterations for the second optimization}
}
\description{
Calculating confidence bands for impulse response functions via wild bootstrap techniques (Goncalves and Kilian, 2004).
}
\examples{
\donttest{
# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.ngml(v1)
summary(x1)

# switching columns according to sign patter
x1$B <- x1$B[,c(3,2,1)]
x1$B[,3] <- x1$B[,3]*(-1)

# impulse response analysis with confidence bands
bb <- wild.boot(x1, rademacher = T, nboot = 100, horizon = 30)
plot(bb, lowerq = 0.16, upperq = 0.84)
}


}
\references{
Goncalves, S., Kilian, L., 2004. Bootstrapping autoregressions with conditional heteroskedasticity of unknown form. Journal of Econometrics 123, 89-120.
}
\seealso{
\code{\link{id.cvm}}, \code{\link{id.dc}}, \code{\link{id.ngml}} or \code{\link{id.cv}}
}
