\name{startSocketServer}
\alias{startSocketServer}
\alias{stopSocketServer}

\title{ Start and stop a R socket server }

\description{
  A R socket server is listening for command send by clients to a TCP port.
  This server is implemented in Tcl/Tk, using the powerful 'socket' command.
  Since it runs in the separate tcltk event loop, it is not blocking R, and it
  runs in the background; the user can still enter commands at the R prompt
  while one or several R socket servers are running and even, possibly,
  processing socket clients requests.
}

\usage{
startSocketServer(port = 8888, server.name = "Rserver", procfun = processSocket,
    secure = FALSE, local = !secure)
stopSocketServer(port = 8888)
}

\arguments{
  \item{port}{ the TCP port of the R socket server. }
  \item{server.name}{ the internal name of this server. }
  \item{procfun}{ the function to use to process client's commands. By default,
    it is \code{processSocket()}. }
  \item{secure}{ do we start a secure (TLS) server? (not implemented yet) }
  \item{local}{ if \code{TRUE}, accept only connections from local clients, i.e.,
    from clients with IP address 127.0.0.1. Set by default if the server is not
    secure. }
}

\details{
  One can write a different \code{procfun} function than the default one for
  special servers. That function must accept one argument (a string with the
  command send by the client) and it must return a character string containing
  the result of the computation.
}

\author{Philippe Grosjean (\email{phgrosjean@sciviews.org})}

\note{ This server is currently synchronous in the processing of the command.
  However, neither R, nor the client are blocked during exchange of data
  (communication is asynchronous).

  Note also that socket numbers are reused, and corresponding configurations
  are not deleted from one connection to the other. So, it is possible for
  a client to connect/disconnect several times and continue to work with the
  same configuration (in particular, the multiline code submitted line by
  line) if every command starts with \code{<<<id=myID>>>} where \code{myID} is
  an alphanumeric (unique) identifier. This property is call a stateful server.
  Take care! The R server never checks uniqueness of this identifier. You are
  responsible to use one that would not intefere with other, concurrent, clients
  connected to the same server.

  For trials and basic testings of the R socket server, you can use the Tcl
  script SimpleClient.Tcl. See the ReadMe.txt file in the /etc/ subdirectory
  of the svSocket package folder. Also, in the source of the svSocket package
  you will find testCLI.R, a script to torture test CLI for R (console).
}

\seealso{ \code{\link{processSocket}} }

\keyword{ IO }

\concept{ stateful socket server interprocess communication }
