% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRIME.R
\docType{data}
\name{PRIME}
\alias{PRIME}
\title{PRIME data set}
\format{
A data frame with 583 observations on 18 variables.
\describe{
\item{Time}{observed time in term of months}
\item{Event}{event or institutionalisation, 1=Yes and 0=No}
\item{Depcen}{dependent right censoring or withdrawal, 1=Yes and 0=No}
\item{Age}{age at baseline, 1=80 years or above and 0=80 year below}
\item{Gender}{gender, 1=Female and 0=Male}
\item{HighEdu}{education level at baseline, 1=high school above and 0=high school
               or below}
\item{Alzheimer}{Alzheimer disease, 1=Yes and 0=No}
\item{CDR_base}{dementia severity at baseline}
\item{MMSE_base}{cognitive ability at baseline}
\item{SMAF_base}{functional ability at baseline}
\item{ZBI_base}{caregiver burden at baseline}
\item{NPI_base}{neuropsychiatric symptoms at baseline}
\item{Benzon}{benzodiazepines taking, 1=Yes and 0=No}
\item{Antiphsy}{anti-psychotics taking, 1=Yes and 0=No}
\item{LivingAlone}{living alone, 1=Yes and 0=No}
\item{MMSE_change_3m}{cognitive ability change at 3-month from baseline}
\item{SMAF_change_3m}{functional ability change at 3-month from baseline}
\item{NPI_change_3m}{neuropsychiatric symptoms change at 3-month from baseline}
}
}
\usage{
data(PRIME)
}
\description{
This data set is from a longitudinal study called "Prospective Research in Memory Clinics" (PRIME),
see Brodaty et al (2011), with a period of 3-year. The data set includes 583 dementia patients. The
outcome is time to institutionalised. The predicators are age, sex, educational level, living status,
dementia type, baseline cognitive ability (MMSE), baseline functional ability (SMAF),
baseline neuropsychiatric symptoms (total NPI), baseline dementia severity (CDR),
baseline caregiver burden (ZBI), medication types, change in cognitive ability at 3 months,
change in functional ability at 3 months, and change in neuropsychiatric symptoms at 3 months.
Note that this data set is complete and was analyzed by Brodaty et al (2014).
}
\references{
Brodaty H, Woodward M, Boundy K, Ames D, Balshaw R. (2011). \emph{"Patients in Australian memory clinics:
baseline characteristics and predictors of decline at six months"}. Int Psychogeriatr 23, 1086-1096.

Brodaty H, Connors M, Xu J, Woodward M, Ames D. (2014). \emph{"Predictors of institutionalization
in dementia: a three year longitudinal study"}. Journal of Alzheimers Disease 40, 221-226.
}
\keyword{datasets}
