% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPenV1_30.r
\name{crs}
\alias{crs}
\title{Bases for cubic regression splines (equivalent to "cr" in \code{mgcv})}
\usage{
crs(x, knots = NULL, df = 10, intercept = TRUE)
}
\arguments{
\item{x}{Numeric vector}

\item{knots}{Numeric vectors that specifies the knots of the splines (including boundaries); default is NULL}

\item{df}{numeric value that indicates the number of knots desired (or degrees of freedom) if knots=NULL; default is 10}

\item{intercept}{if FALSE, the intercept is excluded from the basis; default is TRUE}
}
\value{
List of three elements
\item{bs}{design matrix}
\item{pen}{penalty matrix}
\item{knots}{vector of knots (specified or calculated from \code{df})}
}
\description{
Builds the design matrix and the penalty matrix for cubic regression splines.
}
\details{
See package \code{mgcv} and section 4.1.2 of Wood (2006) for more details about this basis
}
\examples{
x <- seq(1,10,length=100)
# natural cubic spline with 3 knots
crs(x,knots=c(1,5,10))

}
\references{
Wood, S. N. (2006), Generalized additive models: an introduction with R. London: Chapman & Hall/CRC.
}
