% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tne}
\alias{tne}
\alias{tne.Surv}
\alias{tne.coxph}
\alias{tne.formula}
\alias{tne.survfit}
\title{Time, No. at risk, No. events}
\usage{
tne(x, ...)

\method{tne}{Surv}(x, ..., eventsOnly = FALSE)

\method{tne}{survfit}(x, ..., eventsOnly = FALSE, what = c("table", "list",
  "all"), nameStrata = TRUE)

\method{tne}{coxph}(x, ..., eventsOnly = FALSE, what = c("table", "list",
  "all"), nameStrata = TRUE)

\method{tne}{formula}(x, ..., eventsOnly = FALSE, what = c("table", "list",
  "all"), nameStrata = TRUE)
}
\arguments{
\item{x}{A object of class \code{Surv}, \code{survfit},
\code{coxph} or \code{formula}.}

\item{...}{Additional arguments (not implemented)}

\item{eventsOnly}{If \code{eventsOnly=TRUE}
shows only times at which at least one event occurred.
Otherwise shows \emph{all} times recorded
(i.e. including those censored)}

\item{what}{See \bold{Value} below}

\item{nameStrata}{Applies only if \code{what=="list"}
or \code{what=="all"}. The default is to name
the elements of the \code{list} after each stratum.
\cr
As the names for each stratum are made by concatenating the predictor names, this can
become unwieldly.
\cr
If \code{nameStrata="FALSE"} they are instead numbered. A list is returned
with the numbered \code{list} or \code{data.table}
and a \code{vector} giving the names of the strata.}
}
\value{
For a \code{Surv} object: A \code{data.table} with columns:
\item{t}{time}
\item{n}{no. at risk}
\item{e}{no. events}
For a \code{survfit}, \code{coxph} or \code{formula}:
If \code{what="table"} (the default), a
\code{data.table} with columns as above. In addition:
 \item{s}{stratum; predictor names are separated with an underscore '_'}
 \item{ns}{no. at risk (by strata)}
 \item{Es}{no. events expected (by strata)}
 \item{e_Es}{no. events minus no. events expected}
Additional columns returned match those of the predictors in the \code{model.frame}
(for \code{survfit} objects) or \code{model.matrix} (in other cases).
If \code{what="list"} = then instead a \code{list}
with one element for each stratum, where each
elements is a \code{data.table} with columns
\bold{t}, \bold{n} and \bold{e} as for a \code{Surv} object.
If \code{what="all"}, a \code{data.table} with a columns \bold{t}, \bold{n}
and \bold{e} as above.
There are additional columns for \bold{n} and \bold{e} for each stratum.
}
\description{
Time, No. at risk, No. events
}
\note{
The number of events expected (per stratum) is given by:
\deqn{E = \frac{e_i(n[s]_i)}{n_i}}{
      E = e(i)n[s](i) / n(i)}
where \eqn{n[s]_i} is the no. at risk for the stratum.
\cr \cr
If the formula is 'intercept-only', the stratum \code{I=1} is returned.
\cr \cr
Interaction terms are not currently supported by \code{survfit} objects.
}
\examples{
### Surv object
df0 <- data.frame(t=c(1,1,2,3,5,8,13,21),
                  e=rep(c(0,1),4))
s1 <- Surv(df0$t, df0$e, type="right")
tne(s1)
tne(s1, eventsOnly=TRUE)
### survfit object
data(kidney, package="KMsurv")
s1 <- survfit(Surv(time=time, event=delta) ~ type, data=kidney)
tne(s1)
tne(s1, what="all")
tne(s1, what="all", eventsOnly=TRUE)
tne(survfit(Surv(time=time, event=delta) ~ 1, data=kidney))
data(larynx, package="KMsurv")
tne(survfit(Surv(time, delta) ~ factor(stage) + age, data=larynx))
data(bmt, package="KMsurv")
tne(survfit(Surv(t2, d3) ~ z3 +z10, data=bmt), what="all")
tne(survfit(Surv(t2, d3) ~ 1, data=bmt))
### coxph object
data(kidney, package="KMsurv")
c1 <- coxph(Surv(time=time, event=delta) ~ type, data=kidney)
tne(c1)
tne(c1, what="list")
tne(coxph(Surv(t2, d3) ~ z3*z10, data=bmt))
### formula object
data(kidney, package="KMsurv")
### this doesn't work
### s1 <- survfit(Surv(t2, d3) ~ z3*z10, data=bmt)
tne(Surv(time=t2, event=d3) ~ z3*z10, data=bmt, what="all")
tne(Surv(time=t2, event=d3) ~ ., data=bmt)
### example where each list element has only one row
### also names are impractical
tne(Surv(time=t2, event=d3) ~ ., data=bmt, what="list", nameStrata=FALSE)
}
\references{
Example using \code{kidney} data is from:
\bold{K&M}. Example 7.2, pg 210.
}

