% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.nocrossings.R
\name{print.nocrossings}
\alias{print.nocrossings}
\title{Print a nocrossings object}
\usage{
\method{print}{nocrossings}(x, digits = max(3L, getOption("digits") - 3L), quiet = FALSE, ...)
}
\arguments{
\item{x}{the result of a call to the \code{nocrossings} function}

\item{digits}{significant digits to print, the default value is \code{max(3L, getOption("digits") - 3L)}}

\item{quiet}{a logical indicating whether to reduce the amount of output or not, the default value is \code{FALSE}}

\item{...}{for future method}
}
\description{
Returns the decision for rejection of the null hypothesis that there are crossings or alternative orderings among the survival functions.
}
\examples{
library(survELtest)
result = nocrossings(survival::Surv(hepatitis$time, hepatitis$censor)~
             hepatitis$group, sided = 1)
print(result)

## OUTPUT:
## Call:
## nocrossings(formula = survival::Surv(hepatitis$time, hepatitis$censor) ~ 
##     hepatitis$group, sided = 1)
## 
## Decision = 1
}
\seealso{
\code{\link{hepatitis}}, \code{\link{nocrossings}}, \code{\link{summary.nocrossings}}
}
