#' Data for Figure 2
#'
#' The data, taken from \insertCite{c17}{superb}7, is an example where the
#' "stand-alone" 95\\% confidence interval of the means returns
#' a result in contradiction with the result of a statistical test.
#' The paradoxical result is resolved by using adjusted confidence intervals,
#' here the correlation- and different-adjusted confidence interval.
#'
#' @md
#'
#' @docType data
#'
#' @usage data(dataFigure2)
#'
#' @format An object of class data.frame.
#'
#' @keywords datasets
#'
#' @references 
#' \insertAllCited{}
#'
#' @source \doi{10.5709/acp-0214-z}
#'
#' @examples
#' library(ggplot2)
#' library(gridExtra)
#' data(dataFigure2)
#' 
#' options(superb.feedback = 'none') # shut down 'warnings' and 'design' interpretation messages
#' 
#' ## realize the plot with unadjusted (left) and ajusted (right) 95% confidence intervals
#' plt2a <- superbPlot(dataFigure2, WSFactors = "Moment(2)", 
#'     adjustments=list(purpose = "difference"), 
#'     variables = c("pre","post"), plotStyle="bar" ) + 
#'   xlab("Group") + ylab("Score") + labs(title="Difference-adjusted 95% CI\n") +
#'   coord_cartesian( ylim = c(85,115) ) +
#'   geom_hline(yintercept = 100, colour = "black", size = 0.5, linetype=2)
#' plt2b <- superbPlot(dataFigure2, WSFactors = "Moment(2)", 
#'     adjustments=list(purpose = "difference", decorrelation = "CA"), 
#'     variables = c("pre","post"), plotStyle="bar" ) + 
#'   xlab("Group") + ylab("Score") + labs(title="Correlation and difference-adjusted\n95% CI") +
#'   coord_cartesian( ylim = c(85,115) ) + 
#'   geom_hline(yintercept = 100, colour = "black", size = 0.5, linetype=2)
#' plt2  <- grid.arrange(plt2a,plt2b,ncol=2)
#' 
#' ## realise the correct t-test to see the discrepancy
#' t.test(dataFigure2$pre, dataFigure2$post, paired=TRUE)
#' 
"dataFigure2"