% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sudokuAlt.R
\name{fetchAUGame}
\alias{fetchAUGame}
\title{Retrieve a Sudoku from the AU Site}
\usage{
fetchAUGame(day = 0)
}
\arguments{
\item{day}{non-negative integer, how many days ago? zero for
today's game.}
}
\value{
The published sudoku game as a sudoku object.
}
\description{
Retrieve a Sudoku Game
}
\details{
Connects to \url{http://www.sudoku.com.au} and retrieves
the sudoku game from \code{day} days ago.  Based on a function from a
related sudoku package, \code{sudoku::fetchSudokuUK} with minor changes.
}
\examples{
\dontrun{
(g0 <- fetchAUGame())  ## The game for today (according to GMT)
(g3 <- fetchAUGame(3)) ## game from 3 days ago (according to GMT)
if(require(sudoku)) {  ## the original solver
  g0a <- as.sudoku(fetchSudokuAU())
  identical(g0, g0a)   ## should be TRUE
}
}
}
\author{
Bill Venables
}

