% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subprocess.R
\docType{data}
\name{terminating}
\alias{terminating}
\alias{process_wait}
\alias{process_state}
\alias{process_return_code}
\alias{TIMEOUT_INFINITE}
\alias{TIMEOUT_IMMEDIATE}
\title{Terminating a Child Process.}
\format{An object of class \code{integer} of length 1.}
\usage{
process_wait(handle, timeout = TIMEOUT_INFINITE)

process_state(handle)

process_return_code(handle)

TIMEOUT_INFINITE

TIMEOUT_IMMEDIATE
}
\arguments{
\item{handle}{Process handle obtained from \code{spawn_process}.}

\item{timeout}{Optional timeout in milliseconds.}
}
\value{
\code{process_wait()} returns an \code{integer} exit code
of the child process or \code{NA} if the child process has not exited
yet. The same value can be accessed by \code{process_return_code()}.
}
\description{
These functions give access to the state of the child process and to
its exit status (return code).

The \code{timeout} parameter can take one of three values:
\itemize{
\item \code{0} which means no timeout
\item \code{-1} which means "wait until there is data to read"
\item a positive integer, which is the actual timeout in milliseconds
}

\code{TIMEOUT_INFINITE} denotes an "infinite" timeout
(that is, wait until response is available) when waiting for an
operation to complete.

\code{TIMEOUT_IMMEDIATE} denotes an "immediate" timeout
(in other words, no timeout) when waiting for an operation to
complete.
}
\details{
\code{process_wait()} checks the state of the child process
by invoking the system call \code{waitpid()} or
\code{WaitForSingleObject()}.

\code{process_state()} refreshes the handle by calling
\code{process_wait()} with no timeout and returns one of these
values: \code{"not-started"}. \code{"running"}, \code{"exited"},
\code{"terminated"}.

\code{process_return_code()} gives access to the value
returned also by \code{process_wait()}. It does not invoke
\code{process_wait()} behind the scenes.
}
\seealso{
\code{\link[=spawn_process]{spawn_process()}}, \code{\link[=process_read]{process_read()}}
\code{\link[=signals]{signals()}}
}
\keyword{datasets}
