% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite.R
\name{readwrite}
\alias{process_read}
\alias{process_write}
\alias{readwrite}
\title{Communicating with a Child Process}
\usage{
process_read(handle, pipe = "stdout", timeout = TIMEOUT_IMMEDIATE,
  flush = TRUE)

process_write(handle, message)
}
\arguments{
\item{handle}{Process handle obtained from \code{spawn_process}.}

\item{pipe}{Output stream name, \code{"stdout"} or \code{"stderr"}.}

\item{timeout}{Optional timeout in milliseconds.}

\item{flush}{If there is any data within the given \code{timeout}
try again with \code{timeout=0} until C buffer is empty.}

\item{message}{Input for the child process.}
}
\value{
\code{process_read} returns a \code{character} vector
        which contains lines of child's output.

\code{process_write} returns the number of characters
        written.
}
\description{
\code{process_read} reads data from one of the child process' streams,
\emph{standard output} or \emph{standard error output}, and returns
it as a \code{character} vector.

\code{process_write} writes data into child's
\emph{standard input} stream.
}
\details{
If \code{flush=TRUE} in \code{process_read()} then the invocation of
the underlying \code{read()} \emph{system-call} will be repeated until
the pipe buffer is empty.

For details on \code{timeout} see \code{\link{terminating}}.
}

