% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateRegnTables.R
\name{estimateRegnTables}
\alias{estimateRegnTables}
\title{Regression Table Estimation}
\usage{
estimateRegnTables(alpha, mu, sigma, X)
}
\arguments{
\item{alpha}{the estimated alpha variable values for each document}

\item{mu}{the mean (fitted) values for alpha based on document-level variables * estimated 
Gamma for each document}

\item{sigma}{the estimated covariance matrix for the alpha parameters}

\item{X}{the covariates used to estimate the STS model}
}
\value{
a list of tables with regression coefficient estimates. The first 
<num-topic> elements pertain to prevalence; the latter  <num-topic> elements 
pertain to sentiment-discourse.
}
\description{
Estimates regression tables for prevalence and sentiment/discourse.
}
\details{
Estimate Gamma coefficients (along with standard errors, p-values, etc.) to  
assess how document-level meta-data determine prevalence and sentiment/discourse
}
\examples{
\donttest{
library("tm"); library("stm"); library("sts")
temp<-textProcessor(documents=gadarian$open.ended.response,
metadata=gadarian, verbose = FALSE)
out <- prepDocuments(temp$documents, temp$vocab, temp$meta, verbose = FALSE)
X <- model.matrix(~1+out$meta$treatment + out$meta$pid_rep + 
out$meta$treatment * out$meta$pid_rep)[,-1]
X_seed <- as.matrix(out$meta$treatment)
## low max iteration number just for testing
sts_estimate <- sts(X, X_seed, out, numTopics = 3, verbose = FALSE, 
parallelize = FALSE, maxIter = 3, initialization = 'anchor')
regn_tables <- estimateRegnTables(sts_estimate$alpha, mu = sts_estimate$mu, 
sigma = sts_estimate$sigma, X = X)
printRegnTables(regn_tables)
}
}
