\name{chlamydiae}
\alias{chlamydiae}
\docType{data}
\title{
Chlamydiae Sub-Taxa of Global Patterns Data
}
\description{
  A \code{phyloseq} class object containing
  data on 16s rRNA diversity within the Chlamydiae
  bacteria taxon, originally appearing in PNAS.
}
\usage{data(chlamydiae)}
\format{
  The format is:
phyloseq-class experiment-level object.
}

\references{
  McMurdie P.J., Holmes S. (2013). phyloseq: A Bioconductor Package for
  Handling and Analysis of High-Throughput Phylogenetic
  Sequence Data. PLoS ONE 8(4): e61217. \url{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0061217}.

  Caporaso, J. G., et al. (2011). Global patterns of 16S rRNA
  diversity at a depth of millions of sequences per sample. PNAS,
  108, 4516-4522. PMCID: PMC3063599

  This can be viewed/downloaded at:
  \url{http://journals.plos.org/plosone/article?id=10.1371/journal.pone.0061217}

  Sankaran, K and Holmes, S. structSSI: Simultaneous and Selective
  Inference for Grouped or Hierarchically Structured Data. Journal of
  Statistical Software, 59(13), 1-21. 2014. http://jstatsoft.org/v59/i13/


}
\examples{
data(chlamydiae)
}
\keyword{datasets}