% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_startswith}
\alias{stri_endswith}
\alias{stri_endswith_charclass}
\alias{stri_endswith_coll}
\alias{stri_endswith_fixed}
\alias{stri_startswith}
\alias{stri_startswith_charclass}
\alias{stri_startswith_coll}
\alias{stri_startswith_fixed}
\title{Determine if the Start or End of a String Matches a Pattern}
\usage{
stri_startswith(str, ..., fixed, coll, charclass)

stri_endswith(str, ..., fixed, coll, charclass)

stri_startswith_fixed(str, pattern, from = 1L)

stri_endswith_fixed(str, pattern, to = -1L)

stri_startswith_charclass(str, pattern, from = 1L)

stri_endswith_charclass(str, pattern, to = -1L)

stri_startswith_coll(str, pattern, from = 1L, opts_collator = NULL)

stri_endswith_coll(str, pattern, to = -1L, opts_collator = NULL)
}
\arguments{
\item{str}{character vector}

\item{...}{additional arguments passed to the underlying functions;
\code{stri_startswith} and \code{stri_endswith} only}

\item{pattern,fixed,coll,charclass}{character vector defining search patterns;
for more details refer to \link{stringi-search}}

\item{from}{integer vector}

\item{to}{integer vector}

\item{opts_collator}{a named list with \pkg{ICU} Collator's settings
as generated with \code{\link{stri_opts_collator}}; \code{NULL}
for default settings; \code{stri_*_coll} only}
}
\value{
All the functions return a logical vector.
}
\description{
These functions check if a string starts or ends with a
pattern occurrence.
}
\details{
Vectorized over \code{str}, \code{pattern},
and \code{from} or \code{to}.

If \code{pattern} is empty, then the result is \code{NA}
and a warning is generated.

Argument \code{start} controls the start position in \code{str}
at which the \code{pattern} is matched.
On the other hand, \code{to} gives the end position.

Indices given by \code{from} or \code{to} are 1-based,
i.e. an index equal to 1 denotes the first character
in a string, which gives a typical R look-and-feel.

For negative indices in \code{from} or \code{to}, counting starts
at the end of the string. E.g. index -1 denotes the last code point
in the string.

If you would like to test for a pattern match at \emph{any}
position in \code{str}, use \code{\link{stri_detect}}.

\code{stri_startswith} and \code{stri_endswith} are convenience functions.
They call either \code{stri_*_fixed}, \code{stri_*_coll},
or \code{stri_*_charclass}, depending on the argument used.
Unless you are a very lazy person, please refer to the underlying functions
directly for better performance.

Note that testing for a pattern match at the start or end of a string
has not been implemented separately for regex patterns.
For that you may use the "\code{^}" and "\code{$}" metacharacters,
see \link{stringi-search-regex}.
}
\examples{
\donttest{
stri_startswith_charclass(" trim me! ", "\\\\p{WSpace}")
stri_startswith_fixed(c("a1", "a2", "b3", "a4", "c5"), "a")
stri_detect_regex(c("a1", "a2", "b3", "a4", "c5"), "^a")
stri_startswith_fixed("ababa", "ba")
stri_startswith_fixed("ababa", "ba", from=2)
stri_startswith_coll(c("a1", "A2", "b3", "A4", "C5"), "a",
   opts_collator=stri_opts_collator(strength=1))
pat <- stri_paste("\\u0635\\u0644\\u0649 \\u0627\\u0644\\u0644\\u0647 ",
                  "\\u0639\\u0644\\u064a\\u0647 \\u0648\\u0633\\u0644\\u0645XYZ")
stri_endswith_coll("\\ufdfa\\ufdfa\\ufdfaXYZ", pat,
   opts=stri_opts_collator(strength = 1))
}
}
\seealso{
Other search_detect: \code{\link{stri_detect}},
  \code{\link{stri_detect_charclass}},
  \code{\link{stri_detect_coll}},
  \code{\link{stri_detect_fixed}},
  \code{\link{stri_detect_regex}};
  \code{\link{stringi-search}}
}

