% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{string2path}
\alias{string2path}
\alias{string2stroke}
\alias{string2fill}
\title{Convert a String to Paths}
\usage{
string2path(
  text,
  font,
  font_weight = c("normal", "thin", "extra_thin", "light", "medium", "semibold", "bold",
    "extra_bold", "black"),
  font_style = c("normal", "italic", "oblique"),
  tolerance = 5e-05
)

string2stroke(
  text,
  font,
  font_weight = c("normal", "thin", "extra_thin", "light", "medium", "semibold", "bold",
    "extra_bold", "black"),
  font_style = c("normal", "italic", "oblique"),
  tolerance = 5e-05,
  line_width = 0.03
)

string2fill(
  text,
  font,
  font_weight = c("normal", "thin", "extra_thin", "light", "medium", "semibold", "bold",
    "extra_bold", "black"),
  font_style = c("normal", "italic", "oblique"),
  tolerance = 5e-05
)
}
\arguments{
\item{text}{A text to convert to paths.}

\item{font}{A font family (e.g. \code{"Arial"}) or a path to a font file (e.g.
\code{"path/to/font.ttf"}).}

\item{font_weight}{A font weight.}

\item{font_style}{A font style.}

\item{tolerance}{Maximum distance allowed between the curve and its
approximation. For more details, please refer to \href{https://docs.rs/lyon/0.17.5/lyon/#what-is-the-tolerance-variable-in-these-examples}{the documentation of the underlying Rust library}.}

\item{line_width}{Line width of strokes.}
}
\value{
A \code{tibble()} containing these columns:
\describe{
\item{x}{x position of the point on the path, scaled to x / line height. The left side of the first glyph is at x = 0.}
\item{y}{Y position of the point on the path, scaled to y / line height. The baseline of the first line is at y = 0.}
\item{glyph_id}{IDs to distinguish the glyphs.}
\item{path_id}{IDs to distinguish the groups of paths.}
\item{triangle_id}{IDs to distinguish the triangles. \code{string2path()} doesn't contain this column.}
}
}
\description{
\code{string2path()} converts a text to the paths of the width-less outlines of
each glyph. \code{string2stroke()} converts a text to the paths of the outlines,
with the specified line width, of each glyph. \code{string2fill()} converts a text
to the paths of the filled polygon of each glyph.
}
\examples{
available_fonts <- dump_fontdb()

if (nrow(available_fonts) > 0) {
  family <- available_fonts$family[1]
  weight <- available_fonts$weight[1]
  style  <- available_fonts$style[1]

  # string2path() converts a text to paths
  d_path <- string2path("TEXT", family, weight, style)
  if (nrow(d_path) > 0) {
    plot(d_path$x, d_path$y)
    for (p in split(d_path, d_path$path_id)) {
      lines(p$x, p$y)
    }
  }

  # string2stroke() converts a text to strokes
  d_stroke <- string2stroke("TEXT", family, weight, style)
  if (nrow(d_stroke) > 0) {
    plot(d_stroke$x, d_stroke$y)

    # The stroke is split into triangles, which can be distinguished by `triangle_id`
    set.seed(2)
    for (p in split(d_stroke, d_stroke$triangle_id)) {
      polygon(p$x, p$y, col = rgb(runif(1), runif(1), runif(1), 0.8))
    }
  }

  # string2fill() converts a text to filled polygons
  d_fill <- string2fill("TEXT", family, weight, style)
  if (nrow(d_fill) > 0) {
    plot(d_fill$x, d_fill$y)

    # The polygon is split into triangles, which can be distinguished by `triangle_id`
    set.seed(2)
    for (p in split(d_fill, d_fill$triangle_id)) {
      polygon(p$x, p$y, col = rgb(runif(1), runif(1), runif(1), 0.8))
    }
  }
}

}
