% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-nums.R
\name{str_extract_numbers}
\alias{str_extract_numbers}
\title{Extract numbers from a string.}
\usage{
str_extract_numbers(
  string,
  decimals = FALSE,
  leading_decimals = decimals,
  negs = FALSE,
  sci = FALSE,
  big_mark = "",
  leave_as_string = FALSE,
  commas = FALSE
)
}
\arguments{
\item{string}{A string.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{sci}{Make the search aware of scientific notation e.g. 2e3 is the same
as 2000.}

\item{big_mark}{A character. Allow this character to be used as a thousands
separator. This character will be removed from between digits before they
are converted to numeric. You may specify many at once by pasting them
together e.g. \code{big_mark = ",_"} will allow both commas and underscores.
Internally, this will be used inside a \verb{[]} regex block so e.g. \code{"a-z"}
will behave differently to \code{"az-"}. Most common separators (commas, spaces,
underscores) should work fine.}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}

\item{commas}{Deprecated. Use \code{big_mark} instead.}
}
\value{
For \code{str_extract_numbers} and \code{str_extract_non_numerics}, a list of
numeric or character vectors, one list element for each element of
\code{string}. For \code{str_nth_number} and \code{str_nth_non_numeric}, a numeric or
character vector the same length as the vector \code{string}.
}
\description{
Extract the numbers from a string, where decimals, scientific notation and
thousand separators are optionally allowed.
}
\details{
If any part of a string contains an ambiguous number (e.g. \verb{1.2.3} would be
ambiguous if \code{decimals = TRUE} (but not otherwise)), the value returned for
that string will be \code{NA} and a \code{warning} will be issued.

With scientific notation, it is assumed that the exponent is not a decimal
number e.g. \verb{2e2.4} is unacceptable. Thousand separators, however, are
acceptable in the exponent.

Numbers outside the double precision floating point range (i.e. with absolute
value greater than 1.797693e+308) are read as \code{Inf} (or \code{-Inf} if they begin
with a minus sign). This is what \code{base::as.numeric()} does.
}
\examples{
strings <- c(
  "abc123def456", "abc-0.12def.345", "abc.12e4def34.5e9",
  "abc1,100def1,230.5", "abc1,100e3,215def4e1,000"
)
str_extract_numbers(strings)
str_extract_numbers(strings, decimals = TRUE)
str_extract_numbers(strings, decimals = TRUE, leading_decimals = TRUE)
str_extract_numbers(strings, big_mark = ",")
str_extract_numbers(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE
)
str_extract_numbers(strings,
  decimals = TRUE, leading_decimals = TRUE,
  sci = TRUE, big_mark = ",", negs = TRUE
)
str_extract_numbers(strings,
  decimals = TRUE, leading_decimals = FALSE,
  sci = FALSE, big_mark = ",", leave_as_string = TRUE
)
str_extract_numbers(c("22", "1.2.3"), decimals = TRUE)
}
\seealso{
Other numeric extractors: 
\code{\link{str_nth_number_after_mth}()},
\code{\link{str_nth_number_before_mth}()},
\code{\link{str_nth_number}()}
}
\concept{numeric extractors}
