% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinomialGLMsClass.R
\docType{class}
\name{BinomialGLM}
\alias{BinomialGLM}
\title{R6 class for storing the design matrix and the binary outcome for a single GLM (logistic) regression}
\format{An \code{\link{R6Class}} generator object}
\usage{
BinomialGLM
}
\description{
This R6 class can request, store and manage the design matrix Xmat, as well as the binary outcome Bin for the
 logistic regression P(Bin|Xmat).
 Can also be used for converting data in wide format to long when requested,
 e.g., when pooling across binary indicators (fitting one pooled logistic regression model for several indicators)
 The class has methods that perform queries to data storage R6 class DataStorageClass to get appropriate data columns & row subsets
}
\details{
\itemize{
\item{ID} - Vector of observation IDs, \code{1:n}, used for pooling.
\item{outvar} - Outcome name.
\item{predvars} - Predictor names.
\item{subset_vars} - Defines the subset which would be used for fitting this model (logical, expression or indices).
\item{subset_idx} - Subset \code{subset_vars} converted to logical vector.
}
}
\section{Methods}{

\describe{
  \item{\code{new(reg)}}{Uses \code{reg} R6 \code{\link{RegressionClass}} object to instantiate a new storage container for a
  design matrix and binary outcome.}
  \item{\code{setdata()}}{...}
}
}

\section{Active Bindings}{

\describe{
  \item{\code{emptydata}}{...}
  \item{\code{emptyY}}{...}
  \item{\code{emptySubset_idx}}{...}
  \item{\code{getXmat}}{...}
  \item{\code{getY}}{...}
}
}
\keyword{R6}
\keyword{class}

