% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD_ReadDB.R
\name{DSD_ReadDB}
\alias{DSD_ReadDB}
\alias{close_stream.DSD_ReadDB}
\title{Read a Data Stream from an open DB Query}
\usage{
DSD_ReadDB(
  result,
  k = NA,
  outofpoints = c("warn", "ignore", "stop"),
  description = NULL
)

\method{close_stream}{DSD_ReadDB}(dsd, disconnect = TRUE, ...)
}
\arguments{
\item{result}{An open DBI result set.}

\item{k}{Number of true clusters, if known.}

\item{outofpoints}{Action taken if less than \code{n} data points are
available. The default is to return the available data points with a warning. Other supported actions are:
\itemize{
\item \code{warn}: return the available points (maybe an empty data.frame) with a warning.
\item \code{ignore}: silently return the available points.
\item \code{stop}: stop with an error.
}}

\item{description}{a character string describing the data.}

\item{dsd}{a stream.}

\item{disconnect}{logical; disconnect from the database?}

\item{...}{further arguments.}
}
\value{
An object of class \code{DSD_ReadDB} (subclass of  \link{DSD_R}, \link{DSD}).
}
\description{
A DSD class that reads a data stream from an open DB result set from a
relational database with using R's data base interface (DBI).
}
\details{
This class provides a streaming interface for result sets from a data base
with via \link[DBI:DBI-package]{DBI::DBI}. You need to connect to the data base and submit a SQL
query using \code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}} to obtain a result set. Make sure that your
query only includes the columns that should be included in the stream
(including class and outlier marking columns).

\strong{Closing and resetting the stream}

Do not forget to clear the
result set and disconnect from the data base connection.
\code{close_stream()} clears the query result with \code{\link[DBI:dbClearResult]{DBI::dbClearResult()}}
and the disconnects from the database with \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}}. Disconnecting
can be prevented by calling \code{close_stream()} with \code{disconnect = FALSE}.

\code{\link[=reset_stream]{reset_stream()}} is not available for this type of stream.

\strong{Additional information}

If additional information is available (e.g., class information), then the SQL
statement needs to make sure that the columns have the appropriate name starting with \code{.}.
See Examples section below.
}
\examples{
### create a data base with a table with 3 Gaussians
if(require("RSQLite")) {

library("RSQLite")
con <- dbConnect(RSQLite::SQLite(), ":memory:")

points <- get_points(DSD_Gaussians(k = 3, d = 2), n = 110)
head(points)

dbWriteTable(con, "Gaussians", points)

### prepare a query result set. Make sure that the additional information
### column starts with .
res <- dbSendQuery(con, "SELECT X1, X2, `.class` AS '.class' FROM Gaussians")
res

### create a stream interface to the result set
stream <- DSD_ReadDB(res, k = 3)
stream

### get points
get_points(stream, n = 5)

plot(stream, n = 100)

close_stream(stream)
}
}
\seealso{
\code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}

Other DSD: 
\code{\link{DSD_BarsAndGaussians}()},
\code{\link{DSD_Benchmark}()},
\code{\link{DSD_Cubes}()},
\code{\link{DSD_Gaussians}()},
\code{\link{DSD_MG}()},
\code{\link{DSD_Memory}()},
\code{\link{DSD_Mixture}()},
\code{\link{DSD_NULL}()},
\code{\link{DSD_ReadStream}()},
\code{\link{DSD_Target}()},
\code{\link{DSD_UniformNoise}()},
\code{\link{DSD_mlbenchData}()},
\code{\link{DSD_mlbenchGenerator}()},
\code{\link{DSD}()},
\code{\link{DSF}()},
\code{\link{animate_data}()},
\code{\link{close_stream}()},
\code{\link{get_points}()},
\code{\link{plot.DSD}()},
\code{\link{reset_stream}()}
}
\author{
Michael Hahsler
}
\concept{DSD}
