% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSD.R
\name{reset_stream}
\alias{reset_stream}
\title{Reset a Data Stream to its Beginning}
\usage{
reset_stream(dsd, pos = 1)
}
\arguments{
\item{dsd}{An object of class a subclass of \link{DSD} which implements a
reset function.}

\item{pos}{Position in the stream (the beginning of the stream is position
1).}
}
\description{
Resets the counter in a DSD object to the beginning or any other position in
the stream.
}
\details{
Resets the counter of the stream object. For example, for \link{DSD_Memory},
the counter stored in the environment variable is moved back to 1. For
\link{DSD_ReadCSV} objects, this is done by calling \code{seek()} on the
underlying connection.
}
\examples{

# initializing the objects
stream <- DSD_Gaussians(k=3, d=2)
replayer <- DSD_Memory(stream, 100)
replayer

p <- get_points(replayer, 50)
replayer

# reset replayer to the begining of the stream
reset_stream(replayer)
replayer

# set replayer to position 21
reset_stream(replayer, pos=21)
replayer

}
\seealso{
\link{DSD_ReadCSV}, \link{DSD_MG},
\link{DSD_ScaleStream}, \link{DSD_Memory}
}
\author{
Michael Hahsler
}
