/*
 * Decompiled with CFR 0.152.
 */
package moa.streams.generators;

import java.util.Random;
import moa.core.InstancesHeader;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.FlagOption;
import moa.options.IntOption;
import moa.streams.InstanceStream;
import moa.tasks.TaskMonitor;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class WaveformGenerator
extends AbstractOptionHandler
implements InstanceStream {
    private static final long serialVersionUID = 1L;
    public static final int NUM_CLASSES = 3;
    public static final int NUM_BASE_ATTRIBUTES = 21;
    public static final int TOTAL_ATTRIBUTES_INCLUDING_NOISE = 40;
    protected static final int[][] hFunctions = new int[][]{{0, 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0}, {0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 5, 4, 3, 2, 1, 0, 0, 0, 0, 0}};
    public IntOption instanceRandomSeedOption = new IntOption("instanceRandomSeed", 'i', "Seed for random generation of instances.", 1);
    public FlagOption addNoiseOption = new FlagOption("addNoise", 'n', "Adds noise, for a total of 40 attributes.");
    protected InstancesHeader streamHeader;
    protected Random instanceRandom;

    public String getPurposeString() {
        return "Generates a problem of predicting one of three waveform types.";
    }

    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        FastVector<Attribute> attributes = new FastVector<Attribute>();
        int numAtts = this.addNoiseOption.isSet() ? 40 : 21;
        for (int i = 0; i < numAtts; ++i) {
            attributes.addElement(new Attribute("att" + (i + 1)));
        }
        FastVector<String> classLabels = new FastVector<String>();
        for (int i = 0; i < 3; ++i) {
            classLabels.addElement("class" + (i + 1));
        }
        attributes.addElement(new Attribute("class", classLabels));
        this.streamHeader = new InstancesHeader(new Instances(this.getCLICreationString(InstanceStream.class), attributes, 0));
        this.streamHeader.setClassIndex(this.streamHeader.numAttributes() - 1);
        this.restart();
    }

    public long estimatedRemainingInstances() {
        return -1L;
    }

    public InstancesHeader getHeader() {
        return this.streamHeader;
    }

    public boolean hasMoreInstances() {
        return true;
    }

    public boolean isRestartable() {
        return true;
    }

    public Instance nextInstance() {
        int i;
        InstancesHeader header = this.getHeader();
        DenseInstance inst = new DenseInstance(header.numAttributes());
        inst.setDataset(header);
        int waveform = this.instanceRandom.nextInt(3);
        int choiceA = 0;
        int choiceB = 0;
        switch (waveform) {
            case 0: {
                choiceA = 0;
                choiceB = 1;
                break;
            }
            case 1: {
                choiceA = 0;
                choiceB = 2;
                break;
            }
            case 2: {
                choiceA = 1;
                choiceB = 2;
            }
        }
        double multiplierA = this.instanceRandom.nextDouble();
        double multiplierB = 1.0 - multiplierA;
        for (i = 0; i < 21; ++i) {
            inst.setValue(i, multiplierA * (double)hFunctions[choiceA][i] + multiplierB * (double)hFunctions[choiceB][i] + this.instanceRandom.nextGaussian());
        }
        if (this.addNoiseOption.isSet()) {
            for (i = 21; i < 40; ++i) {
                inst.setValue(i, this.instanceRandom.nextGaussian());
            }
        }
        inst.setClassValue(waveform);
        return inst;
    }

    public void restart() {
        this.instanceRandom = new Random(this.instanceRandomSeedOption.getValue());
    }

    public void getDescription(StringBuilder sb, int indent) {
    }
}

