% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heterozygosity.R
\name{heterozygosity}
\alias{heterozygosity}
\title{Heterozygosity}
\usage{
heterozygosity(g, by.strata = FALSE, type = c("expected", "observed"))
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{by.strata}{logical - return results by strata?}

\item{type}{return \code{expected} or \code{observed} heterozygosity}
}
\description{
Calculate observed and heterozygosity.
}
\note{
If \code{g} is a haploid object with sequences, the value for 
  expected heterozygosity (= haplotpyic diversity) will be returned.
}
\examples{
data(msats.g)

# Expected heterozygosity
heterozygosity(msats.g, type = "expected")

# Observed heterozygosity by strata
heterozygosity(msats.g, FALSE, "observed")

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
