% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popStructStat.R
\name{popStructStat}
\alias{popStructStat}
\alias{Hstats}
\alias{statChi2}
\alias{statFis}
\alias{statFst}
\alias{statFstPrime}
\alias{statGst}
\alias{statGstPrime}
\alias{statGstDblPrime}
\alias{statJostD}
\alias{statPhist}
\title{Population structure statistics}
\usage{
Hstats(g)

statChi2(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statFis(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statFst(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statFstPrime(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statGst(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statGstPrime(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE,
  prime.type = c("nei", "hedrick"), ...)

statGstDblPrime(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statJostD(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE, ...)

statPhist(g, nrep = NULL, strata.mat = NULL, keep.null = FALSE,
  model = "K80", gamma = FALSE, pairwise.deletion = TRUE, ...)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{nrep}{number specifying number of permutation replicates to use for 
permutation test.}

\item{strata.mat}{an optional matrix of permuted stratifications. See Notes 
for more details. Ignored if \code{nrep} is not \code{NULL}.}

\item{keep.null}{logical. Keep the null distribution from the 
permutation test?}

\item{...}{optional arguments passed to or from other functions.}

\item{prime.type}{type of G'st to calculate. Can be "nei" or "hedrick".}

\item{model, gamma, pairwise.deletion}{parameters passed to 
\code{\link[ape]{dist.dna}}. Note that defaults for these arguments 
(in particular \code{model}) are the same as in \code{dist.dna}.}
}
\value{
A list with three elements: \describe{
  \item{stat.name}{the name of the statistic.}
  \item{result}{a vector of the statistic estimate and the p-value, 
    if replicates were conducted.}
  \item{null.dist}{a vector of the null distribution from the permutations.}
}
}
\description{
Population structure statistics
}
\note{
If \code{strata.mat} is provided, it must be a numeric matrix of 
  integers from \code{0} to \code{k - 1}, where \code{k} is the number of 
  strata. Each column is a separate permutation and the first column is 
  assumed to represent the original stratification. If not provided 
  (\code{strata.mat = NULL}), stratification is taken from \code{g}. 
  This argument is primarily used internally by \code{\link{popStructTest}}.
}
\references{
\describe{
  \item{Hstats}{Nei, M. and R.K. Chesser. 1983. Estimation of fixation 
    indices and gene diversities. Ann. Hum. Genet. 47:253-259.}
}
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
