% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strap-package.R
\docType{package}
\name{strap-package}
\alias{strap-package}
\alias{strap}
\title{Measuring Morphological Diversity and Evolutionary Tempo}
\description{
A series of functions for stratigraphic analysis of phylogenetic trees.
}
\examples{

# Calculate stratigraphic fit measures treating ages as ranges:
fit.to.strat.1 <- StratPhyloCongruence(trees = Dipnoi$tree,
  ages = Dipnoi$ages, rlen = 0, method = "basic", samp.perm=5,
  rand.perm = 5, hard = TRUE, randomly.sample.ages = FALSE,
  fix.topology = FALSE, fix.outgroup = TRUE,
  outgroup.taxon = "Psarolepis_romeri")

# Show just the output for the input tree(s)
fit.to.strat.1$input.tree.results

}
\references{
Bell, M. A. and Lloyd, G. T., 2015. strap: an R package for plotting phylogenies against stratigraphy and assessing their stratigraphic congruence. \emph{Palaeontology}, \bold{58}, 379-389.
}
\author{
Graeme T. Lloyd <graemetlloyd@gmail.com>>
}
