% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HP.mod.R
\name{var.rwts}
\alias{var.rwts}
\title{Variance of the rescaled weights when estimating the Heligman-Pollard parameters using Bayesian Melding with IMIS.}
\usage{
var.rwts(w)
}
\arguments{
\item{w}{A vector of importance weights corresponding to each row of the mixture of the prior and multivariate gaussian draws.}
}
\value{
A scalar representing the variance of the rescaled weights.
}
\description{
Calculates the variance of the rescaled weights.
}
\note{
Used in the \link{final.resamp} function.
}
\references{
Poole, D. and Raftery, A. (2000). Inference for Deterministic Simulation Models: The Bayesian Melding Approach. Journal of the American Statistical Association 95:1244–1255.

Raftery, A. and Bao, L. (2009). Estimating and Projecting Trends in HIV/AIDS Generalized Epidemics Using Incremental Mixture Importance Sampling. Technical Report 560, Department of Statistics, University of Washington.

Sharrow, D.J., Clark, S.J., Collinson, M.A., Kahn, K. and Tollman, S.M. (2013). The Age Pattern of Increases in Mortality Affected by HIV: Bayesian Fit of the Heligman-Pollard Model to Data from the Agincourt HDSS Field Site in Rural Northeast South Africa. Demogr. Res. 29, 1039–1096.
}
\seealso{
\link{final.resamp} \link{HP.mod}
}
\keyword{Heligman-Pollard}
\keyword{bycatch}
\keyword{mortality}
\keyword{variance}
\keyword{weights}
