% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{undimname}
\alias{undimname}
\title{Undimname an Object}
\usage{
undimname(x, dims = seq_along(dim(x)), rm.dim.lab = TRUE)
}
\arguments{
\item{x}{object with dimnames (usually an array of some kind)}

\item{dims}{integer vector of dimension positions or character vector of dimlabels
specifying the dimensions for which dimnames should be removed. Defaults to all dimensions.}

\item{rm.dim.lab}{logical vector of length 1 specifying whether the dimlabels from
the \code{dims} dimensions should be removed and converted to NA.}
}
\value{
\code{x} without any dimnames for the dimensions specified by \code{dims}.
If a dimlabel existed for the \code{dims} dimensions, they will have been removed
if \code{rm.dim.lab} = TRUE.
}
\description{
\code{undimname} removes dimnames from an object. This function is to allow
for removing dimnames from only certain dimensions specified by \code{dims}.
}
\examples{
# matrix
m <- array(rep.int(NA, times = 4), dim = c(2,2),
   dimnames = list("lower" = c("a","b"),"UPPER" = c("A","B")))
dimnames(m)
m1 <- undimname(m) # remove dimnames from both dimensions
dimnames(m1)
m2 <- undimname(m, rm.dim.lab = FALSE) # keep dimlabels
dimnames(m2)
m3 <- undimname(m, dims = 1) # remove dimnames from only the first dimenion
dimnames(m3)
m4 <- undimname(m, dims = "lower")
dimnames(m4)
all.equal(m3, m4) # same return object
m5 <- undimname(m, dims = 1, rm.dim.lab = FALSE) # keeps dimlabel
dimnames(m5)
# array
a <- unclass(HairEyeColor)
dimnames(a)
a1 <- undimname(a) # removes dimnames from all dimensions
dimnames(a1)
a2 <- undimname(a, rm.dim.lab = FALSE) # keep dimlabels
dimnames(a2)
a3 <- undimname(a, dims = c(1,2)) # remove dimnames from only the first and second dimenions
dimnames(a3)
a4 <- undimname(a, dims = c("Hair","Eye"))
dimnames(a4)
all.equal(a3, a4)
a5 <- undimname(a, dims = c(1,2), rm.dim.lab = FALSE) # keeps dimlabel
dimnames(a5)
}
