% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/str2str_functions.R
\name{not.rownames}
\alias{not.rownames}
\title{Identify Elements That are Not Rownames}
\usage{
not.rownames(x, nm)
}
\arguments{
\item{x}{object with a rownames attribute}

\item{nm}{character vector specifying the elements to test as rownames of \code{x}.}
}
\value{
character vector containing the elements of \code{nm} that are not rownames
of \code{x}.
}
\description{
\code{not.rownames} identifies which elements from \code{nm} are not rownames of \code{x}.
If all elements are rownames, then a character vector of length 0 is returned.
}
\examples{
not.rownames(x = as.matrix(mtcars), nm = c("Mazda RX4","mazda RX4"))
}
