% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stm.R
\name{stm}
\alias{stm}
\title{Spatial and temporal model}
\usage{
stm(pt, poly, df, crsys = NULL,
display_output = FALSE)
}
\arguments{
\item{pt}{a data frame with the first three
fields being 'x', 'y', and 'z' information.}

\item{poly}{(An sf or S4 object)
a polygon shapefile defining the extent of a landscape.
Default: \code{NULL}, in which the spatial extent
of \code{pt} is utilized.}

\item{df}{a vector or 1-column data frame containing
values for the time series.}

\item{crsys}{(string) the EPSG code of the projection
system of the \code{ppt} coordinates. This only used if
\code{poly} argument is \code{NULL}.
See "http://spatialreference.org/" for the list of
EPSG codes for different regions of the world.
As an example, the EPSG code for the British National Grid
projection system is: \code{"EPSG:27700"}.}

\item{display_output}{(logical) display the output.
Default: \code{FALSE}}
}
\value{
A graphics showing the spatial and
temporal model of the simulation.
}
\description{
To generate graphics depicting the spatial
and temporal models of the final simulation
}
\details{
Incorporated into \code{psim_artif} and
\code{psim_real} functions to allow the preview of
the spatial and the temporal model of the simulation.
The spatial model is the strength distribution of
origin which is the likeness of the spatial patterns
to be simulated. The temporal model is the preview
of the trend and seasonal patterns to be expected
from the simulation.
}
\examples{
\dontrun{
#load polygon shapefile
load(file = system.file("extdata", "camden.rda",
package="stppSim"))
camden_boundary = camden$boundary
#read xyz data
data(xyz)
#create a time series
t <- seq(0,5,0.5)
df <- data.frame(data = abs(min(sin(t))) + sin(t))
#run function
stm(pt = xyz, poly=camden_boundary, df=df,
crsys = NULL, display_output = FALSE)
}
}
