% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od2line}
\alias{od2line}
\title{Convert origin-destination data to spatial lines}
\usage{
od2line(
  flow,
  zones,
  destinations = NULL,
  zone_code = names(zones)[1],
  origin_code = names(flow)[1],
  dest_code = names(flow)[2],
  zone_code_d = NA,
  silent = FALSE
)
}
\arguments{
\item{flow}{A data frame representing origin-destination data.
The first two columns of this data frame should correspond
to the first column of the data in the zones. Thus in \code{\link[=cents_sf]{cents_sf()}},
the first column is geo_code. This corresponds to the first two columns
of \code{\link[=flow]{flow()}}.}

\item{zones}{A spatial object representing origins (and destinations
if no separate destinations object is provided) of travel.}

\item{destinations}{A spatial object
representing destinations of travel flows.}

\item{zone_code}{Name of the variable in \code{zones} containing the ids of the zone.
By default this is the first column names in the zones.}

\item{origin_code}{Name of the variable in \code{flow} containing the ids of the zone of origin.
By default this is the first column name in the flow input dataset.}

\item{dest_code}{Name of the variable in \code{flow} containing the ids of the zone of destination.
By default this is the second column name in the flow input dataset or the first column name in the
destinations if that is set.}

\item{zone_code_d}{Name of the variable in \code{destinations} containing the ids of the zone.
By default this is the first column names in the destinations.}

\item{silent}{TRUE by default, setting it to TRUE will show you the matching columns}
}
\description{
Origin-destination ('OD') flow data is often provided
in the form of 1 line per flow with zone codes of origin and destination
centroids. This can be tricky to plot and link-up with geographical data.
This function makes the task easier.
}
\details{
Origin-destination (OD) data is often provided
in the form of 1 line per OD pair, with zone codes of the trip origin in the first
column and the zone codes of the destination in the second column
(see the \href{https://docs.ropensci.org/stplanr/articles/stplanr-od.html}{\code{vignette("stplanr-od")}}) for details.
\code{od2line()} creates a spatial (linestring) object representing movement from the origin
to the destination for each OD pair.
It takes data frame containing
origin and destination cones (\code{flow}) that match the first column in a
a spatial (polygon or point) object (\code{zones}).
}
\examples{
od_data <- stplanr::flow[1:20, ]
l <- od2line(flow = od_data, zones = cents_sf)
plot(sf::st_geometry(cents_sf))
plot(l, lwd = l$All / mean(l$All), add = TRUE)
}
\seealso{
Other od: 
\code{\link{od2odf}()},
\code{\link{od_aggregate_from}()},
\code{\link{od_aggregate_to}()},
\code{\link{od_coords2line}()},
\code{\link{od_coords}()},
\code{\link{od_id_order}()},
\code{\link{od_id}},
\code{\link{od_oneway}()},
\code{\link{od_to_odmatrix}()},
\code{\link{odmatrix_to_od}()},
\code{\link{points2flow}()},
\code{\link{points2odf}()}
}
\concept{od}
