% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{line2route}
\alias{line2route}
\title{Convert straight OD data (desire lines) into routes}
\usage{
line2route(
  l,
  route_fun = stplanr::route_cyclestreets,
  n_print = 10,
  list_output = FALSE,
  l_id = NA,
  time_delay = 0,
  ...
)
}
\arguments{
\item{l}{A spatial (linestring) object}

\item{route_fun}{A routing function to be used for converting the straight lines to routes
\code{\link[=od2line]{od2line()}}}

\item{n_print}{A number specifying how frequently progress updates
should be shown}

\item{list_output}{If FALSE (default) assumes spatial (linestring) object output. Set to TRUE to save output as a list.}

\item{l_id}{Character string naming the id field from the input lines data,
typically the origin and destination ids pasted together. If absent, the row name of the
straight lines will be used.}

\item{time_delay}{Number or seconds to wait between each query}

\item{...}{Arguments passed to the routing function, e.g. \code{\link[=route_cyclestreets]{route_cyclestreets()}}}
}
\description{
Convert straight OD data (desire lines) into routes
}
\section{Details}{


See \code{\link[=route_cyclestreets]{route_cyclestreets()}} and other route functions for details.

A parallel implementation of this was available until version 0.1.8.
}

\examples{
\dontrun{
# does not run as requires API key
l <- flowlines[2:5, ]
r <- line2route(l)
rq <- line2route(l = l, plan = "quietest", silent = TRUE)
rsc <- line2route(l = l, route_fun = cyclestreets::journey)
plot(r)
plot(r, col = "red", add = TRUE)
plot(rq, col = "green", add = TRUE)
plot(rsc)
plot(l, add = T)
# Plot for a single line to compare 'fastest' and 'quietest' route
n <- 2
plot(l[n, ])
lines(r[n, ], col = "red")
lines(rq[n, ], col = "green")
}
}
\seealso{
Other routes: 
\code{\link{line2routeRetry}()},
\code{\link{route_dodgr}()},
\code{\link{route_local}()},
\code{\link{route_transportapi_public}()},
\code{\link{route}()}
}
\concept{routes}
