% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs-funs.R
\name{crs_select_aeq}
\alias{crs_select_aeq}
\title{Select a custom projected CRS for the area of interest}
\usage{
crs_select_aeq(shp)
}
\arguments{
\item{shp}{A spatial object with a geographic (WGS84) coordinate system}
}
\description{
This function takes a spatial object with a geographic (WGS84)
CRS and returns a custom projected CRS focussed on the centroid of the object.
This function is especially useful for using units of metres in all directions
for data collected anywhere in the world.
}
\details{
The function is based on this stackexchange answer:
\url{http://gis.stackexchange.com/questions/121489}
}
\examples{
data("routes_fast")
new_crs <- crs_select_aeq(routes_fast)
plot(routes_fast)
rf_projected <- sp::spTransform(routes_fast, new_crs)
plot(rf_projected)
sp::bbox(rf_projected)
line_length <- rgeos::gLength(rf_projected, byid = TRUE)
plot(line_length, rf_projected$length)
cor(line_length, rf_projected$length)
}
\seealso{
Other geo: \code{\link{bbox_scale}},
  \code{\link{buff_geo}}, \code{\link{decode_gl}},
  \code{\link{gclip}}, \code{\link{geo_bb_matrix}},
  \code{\link{geo_bb}}, \code{\link{mapshape_available}},
  \code{\link{mapshape}}, \code{\link{quadrant}},
  \code{\link{reproject}}
}
\concept{geo}
