% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mp.R
\name{get_mp}
\alias{get_mp}
\title{Extract information on specific MPs}
\usage{
get_mp(mpid = NA, good_manners = 0)
}
\arguments{
\item{mpid}{Character string indicating the id of the MP to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{death} \tab MP date of death, if applicable \cr
   \strong{last_name} \tab MP last name \cr
   \strong{birth} \tab MP date of birth \cr
   \strong{first_name} \tab MP first name \cr
   \strong{id} \tab MP id \cr
   \strong{gender} \tab MP gender \cr
}
}
\description{
A function for retrieving information on Norwegian MPs from the parliament API
}
\examples{
\dontrun{
# Request one MP by id
get_mp("AAMH")

# Request several MPs by id
ids <- c("AAMH", "AMSK", "MAAA")

mps <- lapply(ids, get_mp, good_manners = 2)

mps <- do.call(rbind, mps)
}

}
\seealso{
\link{get_mp_bio} \link{get_parlperiod_mps} \link{get_mp_pic} \link{get_session_mp_speech_activity}
}
