% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/willoughby2006eqs.R
\name{will10b}
\alias{will10b}
\title{Calculate n for the Willoughby model}
\usage{
will10b(vmax_gl, tclat)
}
\arguments{
\item{vmax_gl}{Numeric vector of the tangential wind component of the maximum
gradient wind speed, in meters per second}

\item{tclat}{Numeric vector of the absolute value of latitude, in degrees.}
}
\value{
A numeric vector for \eqn{n}, a parameter needed for the Willoughby wind
   model.
}
\description{
Calculates \eqn{n}, a parameter for the Willoughby model, using equation 10b
(Willoughby et al. 2006).
}
\details{
This function is calculating the equation:
   \deqn{n = 0.4067 + 0.0144 V_{max,G} - 0.0038 \phi}{
   n = 0.4067 + 0.0144 vmax_gl - 0.0038 \phi}
   where:
   \itemize{
     \item{\eqn{n}: Parameter for the Willoughby wind model}
     \item{\eqn{V_{max,G}}{vmax_gl}:  Maximum gradient-level 1-min sustained
        wind (m / s)}
     \item{\eqn{\phi}: Latitude, in decimal degrees}
   }
}
\references{
Willoughby HE, Darling RWR, and Rahn ME. 2006. Parametric representation
of the primary hurricane vortex. Part II: A new family of sectionally
continuous profiles. Monthly Weather Review 134(4):1102-1120.
}

