% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_effects.R
\name{createRandomEffectsModel}
\alias{createRandomEffectsModel}
\title{Create a \code{RandomEffectsModel} object}
\usage{
createRandomEffectsModel(num_components, num_groups)
}
\arguments{
\item{num_components}{Number of "components" or bases defining the random effects regression}

\item{num_groups}{Number of random effects groups}
}
\value{
\code{RandomEffectsModel} object
}
\description{
Create a \code{RandomEffectsModel} object
}
\examples{
n <- 100
rfx_group_ids <- sample(1:2, size = n, replace = TRUE)
rfx_basis <- matrix(rep(1.0, n), ncol=1)
num_groups <- length(unique(rfx_group_ids))
num_components <- ncol(rfx_basis)
rfx_model <- createRandomEffectsModel(num_components, num_groups)
}
