% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{sample_without_replacement}
\alias{sample_without_replacement}
\title{Draw \code{sample_size} samples from \code{population_vector} without replacement, weighted by \code{sampling_probabilities}}
\usage{
sample_without_replacement(
  population_vector,
  sampling_probabilities,
  sample_size
)
}
\arguments{
\item{population_vector}{Vector from which to draw samples.}

\item{sampling_probabilities}{Vector of probabilities of drawing each element of \code{population_vector}.}

\item{sample_size}{Number of samples to draw from \code{population_vector}. Must be less than or equal to \code{length(population_vector)}}
}
\value{
Vector of size \code{sample_size}
}
\description{
Draw \code{sample_size} samples from \code{population_vector} without replacement, weighted by \code{sampling_probabilities}
}
\examples{
a <- as.integer(c(4,3,2,5,1,9,7))
p <- c(0.7,0.2,0.05,0.02,0.01,0.01,0.01)
num_samples <- 5
sample_without_replacement(a, p, num_samples)
}
