% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_enriched_themes.R
\name{get_enriched_themes}
\alias{get_enriched_themes}
\title{Find over-represented themes in a collection}
\usage{
get_enriched_themes(
  test_collection,
  background_collection = NULL,
  top_m = 10,
  weights = list(choice = 3, major = 2, minor = 1),
  explicit = TRUE,
  min_freq = 1,
  blacklist = NULL,
  metric = c("hgt", "tfidf")
)
}
\arguments{
\item{test_collection}{A \code{\link[=Collection]{Collection()}} class object of stories to assay
for over-represented themes.}

\item{background_collection}{A \code{\link[=Collection]{Collection()}} class object the stories of
are a superset of the \code{test_collection} stories.

If \code{NULL}, the collection of all stories in the actively loaded
\acronym{LTO} version is used.}

\item{top_m}{Maximum number of themes to report. The default is \code{top_m=10}.

If \code{Inf}, all themes occurring at least \code{min_occurrence} times in the
collection are reported.}

\item{weights}{A list assigning nonnegative weights to choice, major, and
minor theme levels. The default weighting
\code{list(choice = 3, major = 2, minor = 1)} counts each \emph{choice} usage
three times, each \emph{major} theme usage twice, and each \emph{minor}
theme usage once. Use the uniform weighting
\code{list(choice = 1, major = 1, minor = 1)} weights theme usages equally
regardless of level. At least one weight must be positive.}

\item{explicit}{Set to \code{FALSE} to include ancestor themes of the explicit
thematic annotations.}

\item{min_freq}{Drop themes occurring less than this number of times from
the analysis. The default \code{min_freq=1} results in no themes are discarded.}

\item{blacklist}{A \code{\link[=Themeset]{Themeset()}} class object. A themeset containing themes
to be dropped from the analysis.

If \code{NULL}, no themes are filtered.}

\item{metric}{A character vector specifying the choice of scoring function.
Use \code{metric = "hgt"} for the \emph{hypergeometric test}, and
\code{metric = "tfidf"} for \emph{term frequency-inverse document frequency}.
The default specification of \code{metric = c("hgt", "tfidf")} results in
the hypergeometric test being used in the analysis.}
}
\value{
Returns a \code{\link[tibble]{tibble}} with \code{top_m} rows (themes)
and 10 columns:
\tabular{ll}{
\code{theme_name}: \tab \code{m}-th most over-represented theme in the test
collection\cr
\code{k}: \tab Number of test collection stories featuring the theme\cr
\code{k_bar}: \tab Weighted counts of the theme summed over the test
collection stories\cr
\code{n}: \tab Number of stories in the test collection\cr
\code{n_bar}: \tab Sum of all weighted counts of test collection themes\cr
\code{K}: \tab Number of background collection stories featuring the theme\cr
\code{K_bar}: \tab Weighted counts of the theme summed over the background
collection stories\cr
\code{N}: \tab Number of stories in the background collection\cr
\code{N_bar}: \tab Sum of all weighted counts of background collection
themes\cr
\code{score}: \tab Either the negative base 10 logarithm of the Hypergeometric
test (if \code{metric = "hgt"}) or TF-IDF (if \code{metric = "tfidf"})\cr
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_enriched_themes()} calculates the top \code{m} most over-represented (or
enriched) themes in a sub-collection of interest from a background
collection.
}
\details{
The test collection of \code{n} stories, \eqn{S[1], \ldots, S[n]}, is
represented as a weighted bag-of-words, where each \emph{choice} theme in
story \eqn{S[j] (j=1, \ldots, n)} is counted \code{weights$choice} times,
each \emph{major} theme \code{weights$major} times, and each \emph{minor}
theme \code{weights$choice} times.

The background collection of \code{N} stories, \eqn{S[1], \ldots, S[N]}, is a
superset of the test collection that is likewise represented as a weighted
bag-of-words.

Theme enrichment scores are calculated according to the hypergeometric test
by default. Set \code{metric = "tfidf"} to use TF-IDF weights for the enrichment
scores.
}
\examples{
\dontrun{
# Retrieve the top 10 most enriched themes in "The Twilight Zone" (1959)
# series episodes with all demo version stories as background:
set_lto("demo")
test_collection <- Collection$new(collection_id = "Collection: tvseries: The Twilight Zone (1959)")
result_tbl <- get_enriched_themes(test_collection)
result_tbl

# Run the same analysis on "The Twilight Zone" (1959) series without
# including minor level themes:
result_tbl <- get_enriched_themes(test_collection, weights = list(choice = 1, major = 1, minor = 0))
result_tbl
}
}
\references{
Mikael Onsjö, Paul Sheridan (2020). Theme Enrichment Analysis: A
Statistical Test for Identifying Significantly Enriched Themes in a List of
Stories with an Application to the Star Trek Television Franchise.
\emph{Digital Studies/le Champ Numérique}, 10(1), 1. DOI:
\doi{10.16995/dscn.316}
}
