% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_similar_stories.R
\name{get_similar_stories}
\alias{get_similar_stories}
\title{Find similar stories to a given story}
\usage{
get_similar_stories(
  query_story,
  background_collection = NULL,
  top_n = 10,
  weights = list(choice = 3, major = 2, minor = 1),
  explicit = TRUE,
  min_freq = 1,
  blacklist = NULL,
  metric = c("hgt", "tfidf")
)
}
\arguments{
\item{query_story}{A \code{\link[=Story]{Story()}} class object defining a story of interest.
Thematically similar stories to this one will be returned.}

\item{background_collection}{A \code{\link[=Collection]{Collection()}} class object the stories in
which to search for similar stories to the \code{query_story} input story.

If \code{NULL}, the collection of all stories in the actively loaded
\acronym{LTO} version is used.}

\item{top_n}{Maximum number of similar stories to report. The default is
\code{top_n=10}.

If \code{Inf}, all stories in the background collection are reported.}

\item{weights}{A list assigning nonnegative weights to choice, major, and
minor theme levels. The default weighting
\code{list(choice = 3, major = 2, minor = 1)} counts each \emph{choice} usage
three times, each \emph{major} theme usage twice, and each \emph{minor}
theme usage once. Use the uniform weighting
\code{list(choice = 1, major = 1, minor = 1)} weights theme usages equally
regardless of level. At least one weight must be positive.}

\item{explicit}{Set to \code{FALSE} to include ancestor themes of the explicit
thematic annotations.}

\item{min_freq}{Drop themes occurring less than this number of times from
the analysis. The default \code{min_freq=1} results in no themes are discarded.}

\item{blacklist}{A \code{\link[=Themeset]{Themeset()}} class object. A themeset containing themes
to be dropped from the analysis.

If \code{NULL}, no themes are filtered.}

\item{metric}{A character vector specifying the choice of weighting to use
in the \emph{cosine similarity} measure used to evaluate story thematic
similarity.
Use \code{metric = "hgt"} for hypergeometric test P-value weights and
\code{metric = "tfidf"} for TF-IDF weights.

The default specification of \code{metric = c("hgt", "tfidf")} results in
hypergeometric test P-values being used as weights.}
}
\value{
Returns a \code{\link[tibble]{tibble}} with \code{top_n} rows (stories)
and 5 columns:
\tabular{ll}{
\code{story_id}: \tab \code{n}-th most thematically similar story to the query
story\cr
\code{title}: \tab Reference story title\cr
\code{description}: \tab Reference story description\cr
\code{score}: \tab Cosine similarity score with hypergeometric test weights
(if \code{metric = "hgt"}) or TF-IDF weights (if \code{metric = "tfidf"}).\cr
\code{common_themes}: \tab List of themes common to both the query and
reference story\cr
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

\code{get_similar_stories} calculates the top \code{n} most thematically
similar stories to a given story.
}
\examples{
\dontrun{
# Retrieve the top 10 most similar stories to the classic "The Twilight
# Zone" series episode "Nightmare at 20,000 Feet" (1959):
set_lto("demo")
query_story <- Story$new(story_id = "tz1959e5x03")
result_tbl <- get_similar_stories(query_story)
result_tbl

# Retrieve the top 10 most similar stories to the classic "The Twilight 
# Zone" series episode "Nightmare at 20,000 Feet" (1959) without taking
# minor themes into account:
set_lto("demo")
query_story <- Story$new(story_id = "tz1959e5x03")
result_tbl <- get_similar_stories(query_story, weights = list(choice = 3, major = 2, minor = 0))
result_tbl

# Retrieve the top 10 most similar stories to the classic "The Twilight 
# Zone" series episode "Nightmare at 20,000 Feet" (1959) when implicitly
# featured themes are included in the similarity calculation:
set_lto("demo")
query_story <- Story$new(story_id = "tz1959e5x03")
result_tbl <- get_similar_stories(query_story, explicit = FALSE)
result_tbl
}
}
\references{
Paul Sheridan, Mikael Onsjö, Claudia Becerra, Sergio Jimenez, Georg Dueñas
(2019). \emph{An Ontology-Based Recommender System with an Application to
the Star Trek Television Franchise}. \emph{Future Internet}, 11(9), 182.
DOI: \doi{10.3390/fi11090182}
}
