% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/def_storysets.r
\docType{class}
\name{storysets}
\alias{storysets}
\title{Storysets objects}
\description{
The \pkg{stoRy} package uses the \code{storysets} object 
to store lists of story IDs.
}
\section{Fields}{


Each storysets object has the following five fields
\describe{
\item{file}{A string specifying the name of an .smt format
storysets file. See examples.}
\item{names}{A vector of storyset names.}
\item{comments}{A vector of comments describing the storysets.}
\item{no_of_storysets}{The number of storysets in the .smt file.}
\item{storysets_story_ids}{A list of vectors containing the storyset story IDs.}}
}

\examples{
#######################################################################
# List all storysets files available in the \pkg{stoRy} package       #
#######################################################################
list.files(system.file("storysets", package = "stoRy"))

#######################################################################
# Load the Star Trek aliens storysets smt file and storysets object   #
#######################################################################
file <- system.file("storysets", "aliens.smt", package = "stoRy")
mystorysets <- storysets$new(file)
print(mystorysets)
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{storysets$new()}}
\item \href{#method-print}{\code{storysets$print()}}
\item \href{#method-clone}{\code{storysets$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{storysets$new(file)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{storysets$print(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{storysets$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
