% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stm_diag.R
\name{get_diag}
\alias{get_diag}
\title{computes stm model diagnostics}
\usage{
get_diag(models, outobj)
}
\arguments{
\item{models}{A list of stm models.}

\item{outobj}{The \code{out} object containing documents for all stm models.}
}
\value{
Returns model diagnostics in a tidy data frame.
}
\description{
\code{ get_diag()} is a helper function to compute average and median
\code{\link[stm]{semanticCoherence}} and \code{\link[stm]{exclusivity}} for
a number of  \code{\link[stm]{stm}} models. The function does not work for
models with content covariates.
}
\examples{

library(stm)
library(dplyr)
library(ggplot2)
library(quanteda)

# prepare data
data <- corpus(gadarian, text_field = 'open.ended.response')
docvars(data)$text <- texts(data)
data <- dfm(data, stem = TRUE, remove = stopwords('english'),
            remove_punct = TRUE)
out <- convert(data, to = 'stm')

# fit models
gadarian_3 <- stm(documents = out$documents,
                  vocab = out$vocab,
                  data = out$meta,
                  prevalence = ~ treatment + s(pid_rep),
                  K = 3,
                  max.em.its = 1, # reduce computation time for example
                  verbose = FALSE)

gadarian_5 <- stm(documents = out$documents,
                  vocab = out$vocab,
                  data = out$meta,
                  prevalence = ~ treatment + s(pid_rep),
                  K = 5,
                  max.em.its = 1, # reduce computation time for example
                  verbose = FALSE)

# get diagnostics
diag <- get_diag(models = list(
                 model_3 = gadarian_3,
                 model_5 = gadarian_5),
                 outobj = out)
\dontrun{
# plot diagnostics
diag \%>\%
ggplot(aes(x = coherence, y = exclusivity, color = statistic))  +
  geom_text(aes(label = name), nudge_x = 5) + geom_point() +
  labs(x = 'Semantic Coherence', y = 'Exclusivity') + theme_light()
}

}
