% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csb_date_parse.R
\name{csb_date_parse}
\alias{csb_date_parse}
\title{Parse CSB Date and Time Variables}
\usage{
csb_date_parse(.data, var, day, month, year, drop = FALSE)
}
\arguments{
\item{.data}{A tibble or data frame}

\item{var}{name of column containing date data}

\item{day}{Optional; returns a named column with parsed day}

\item{month}{Optional; returns a named column with parsed month}

\item{year}{Optional; returns a named column with parsed year}

\item{drop}{A logical scalar; if \code{TRUE}, removes the original column
that had contained date and time data, otherwise if \code{FALSE}
the original column is retained.}
}
\value{
Returns a tibble with new columns containing parsed date information
}
\description{
\code{csb_date_parse} is used to parse out dates into
    day, month, and year elements.
}
\examples{
csb_date_parse(january_2018, datetimeinit, dayInit)
csb_date_parse(january_2018, datetimeinit, dayInit, monthInit)
csb_date_parse(january_2018, datetimeinit, month = monthInit)
csb_date_parse(january_2018, datetimeinit, month = monthInit, year = yearInit)
csb_date_parse(january_2018, datetimeinit, dayInit, monthInit, yearInit, drop = TRUE)

}
