% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{hp_data}
\alias{hp_data}
\title{London House Price dataset (Terraced, 2018-2024)}
\format{
A tibble with 1888 rows and 13 columns.
\describe{
\item{price}{The house price in £1000s}
\item{priceper}{The house price per square metre in £s}
\item{tfa}{Total floor area}
\item{dot}{Date of transfer (sale))}
\item{yot}{Year of transfer (sale)}
\item{beds}{Number of bedrooms}
\item{type}{House type - here all \code{T} (terraced)}
\item{cef}{Current energy efficiency rating (values from 0-100)}
\item{pef}{Potential energy efficiency rating (values from 0-100)}
\item{ageb}{The age band of the house constructtion}
\item{lad}{The local authority district code of the property location}
\item{X}{Easting in metres derived from the geometric centroid (in OSGB projecttion - EPSG 27700) of the postcode of the sale}
\item{Y}{Northing in metres derived from the geometric centroid (in OSGB projecttion - EPSG 27700) of the postcode of the sale}
}
}
\source{
Chi, Bin, Dennett, Adam, Oléron-Evans, Thomas and Robin Morphet. 2025. House Price per Square Metre in England and Wales (https://data.london.gov.uk/dataset/house-price-per-square-metre-in-england-and-wales)
}
\usage{
hp_data
}
\description{
A dataset of a sample terraced houses sales in the London area for 2018 to 2024.
}
\examples{
data("hp_data")
}
\keyword{datasets}
