% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mlgcp.r
\name{fit_mlgcp}
\alias{fit_mlgcp}
\title{Marked spatial log-Gaussian Cox process (mLGCP)}
\usage{
fit_mlgcp(
  locs,
  sf,
  marks,
  smesh,
  parameters = list(),
  methods,
  strfixed = matrix(1, nrow = nrow(locs), ncol = ncol(marks)),
  fields = rep(1, ncol(marks)),
  covariates,
  pp_covariates,
  marks_covariates,
  tmb_silent = TRUE,
  nlminb_silent = TRUE,
  ...
)
}
\arguments{
\item{locs}{A \code{data.frame} of \code{x} and \code{y} locations, 2xn.}

\item{sf}{An \code{sf} of type \code{POLYGON} specifying the spatial region
of the domain.}

\item{marks}{A matrix of marks for each observation of the point pattern.}

\item{smesh}{A Delaunay triangulation of the spatial domain returned by \code{fmesher::fm_mesh_2d()}.}

\item{parameters}{a list of named parameters:
log_tau, log_kappa, betamarks, betapp, marks_coefs_pp.}

\item{methods}{An integer value:
\itemize{
\item \code{0} (default), Gaussian distribution, parameter estimated is mean;
\item \code{1}, Poisson distribution, parameter estimated is intensity;
\item \code{2}, binomial distribution, parameter estimated is logit/probability;
\item \code{3}, gamma distribution, the implementation in TMB is shape-scale.
}}

\item{strfixed}{A matrix of fixed structural parameters, defined for each event and mark.
Defaults to \code{1}. If mark distribution
\itemize{
\item Normal, then this is the log of standard deviation;
\item Poisson, then not used;
\item Binomial, then this is the number of trials;
\item Gamma, then this is the log of the scale.
}}

\item{fields}{A binary vector indicating whether there is a new random
field for each mark. By default, each mark has its own random field.}

\item{covariates}{Covariate(s) corresponding to each area in the spatial mesh}

\item{pp_covariates}{Which columns of the covariates apply to the point process}

\item{marks_covariates}{Which columns of the covariates apply to the marks.
By default, all covariates apply to the marks only.}

\item{tmb_silent}{Logical, if \code{TRUE} (default) then
TMB inner optimisation tracing information will be printed.}

\item{nlminb_silent}{Logical, if \code{TRUE} (default) then for each iteration
\code{nlminb()} output will be printed.}

\item{...}{optional extra arguments to pass into \code{stats::nlminb()}.}
}
\value{
A list containing components of the fitted model, see \code{TMB::MakeADFun}. Includes
\itemize{
\item \code{par}, a numeric vector of estimated parameter values;
\item \code{objective}, the objective function; and
\item \code{gr}, the TMB calculated gradient function.
}
}
\description{
Fit a marked LGCP using Template Model Builder (TMB) and the \code{R_inla}
namespace for the SPDE-based construction of the latent field.
}
\details{
The random intensity surface of the point process is (as \code{\link{fit_lgcp}})
\eqn{\Lambda(\boldsymbol{x}) = \textrm{exp}(\boldsymbol{X}\beta + G(\boldsymbol{x}) + \epsilon)},
for design matrix \eqn{\boldsymbol{X}}, coefficients \eqn{\boldsymbol{\beta}}, and random error \eqn{\epsilon}.

Each mark, \eqn{m_j}, is jointly modelled and has their own random field
\eqn{M_j(s) = f^{-1}((\boldsymbol{X}\beta)_{m_j} + G_{m_j}(\boldsymbol{x}) + \alpha_{m_j}\; G(\boldsymbol{x}) + \epsilon_{m_j})}
where \eqn{\alpha_{.}} are coefficient(s) linking the point process and the mark(s).

 \eqn{M_j(s)} depends on the distribution of the marks. If the marks are from a Poisson distribution, it is
the intensity (as with the point process). If the marks are from a Binomial distribution, it is the
success probability, and the user must supply the number of trials for each event (via \code{strfixed}).
If the marks are normally distributed then this models the mean, and the user must supply
the standard deviation (via \code{strfixed}). The user can choose for the point processes and the marks to
share a common GMRF, i.e. \eqn{G_m(s) = G_{pp}(s)}; this is controlled via the argument \code{fields}.
}
\examples{
\donttest{
### ********************** ###
## A joint likelihood marked LGCP model
### ********************** ###
if(requireNamespace("fmesher")){
data(marked, package = "stelfi")
loc.d <- 3 * cbind(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0))
domain <- sf::st_sf(geometry = sf::st_sfc(sf::st_polygon(list(loc.d))))
smesh <- fmesher::fm_mesh_2d(loc.domain = loc.d, offset = c(0.3, 1),
max.edge = c(0.3, 0.7), cutoff = 0.05)
locs <- cbind(x = marked$x, y = marked$y)
marks <- cbind(m1 = marked$m1) ## Gaussian mark
parameters <- list(betamarks = matrix(0, nrow = 1, ncol = ncol(marks)),
log_tau = rep(log(1), 2), log_kappa = rep(log(1), 2),
marks_coefs_pp = rep(0, ncol(marks)), betapp = 0)
fit <- fit_mlgcp(locs = locs, marks = marks,
sf = domain, smesh = smesh,
parameters = parameters, methods = 0,fields = 1)
}
}
}
\references{
Lindgren, F., Rue, H., and Lindström, J. (2011)
An explicit link between Gaussian fields and Gaussian Markov random fields: the stochastic
partial differential equation approach. \emph{Journal of the Royal Statistical Society: Series B
(Statistical Methodology)}, \strong{73}: 423--498.
}
\seealso{
\code{\link{fit_lgcp}}
}
